/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.jdbc.packet.server;

import kd.bos.flydb.jdbc.packet.common.DataType;
import kd.bos.flydb.jdbc.packet.server.AbstractServerPacket;

public class ColumnDefinitionPacket
extends AbstractServerPacket {
    String catalog;
    String schema;
    String table;
    String name;
    String columnAlias;
    byte serverCharsetId;
    long columnLength;
    DataType dataType;
    int precision;
    int scale;

    private ColumnDefinitionPacket(Builder builder) {
        super(builder.sequenceId);
        this.catalog = builder.catalog;
        this.schema = builder.schema;
        this.table = builder.table;
        this.name = builder.name;
        this.columnAlias = builder.columnAlias;
        this.serverCharsetId = builder.serverCharsetId;
        this.columnLength = builder.columnLength;
        this.dataType = builder.dataType;
        this.precision = builder.precision;
        this.scale = builder.scale;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getTable() {
        return this.table;
    }

    public String getName() {
        return this.name;
    }

    public String getColumnAlias() {
        return this.columnAlias;
    }

    public byte getServerCharsetId() {
        return this.serverCharsetId;
    }

    public long getColumnLength() {
        return this.columnLength;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ColumnDefinitionPacket[] toArray() {
        return new ColumnDefinitionPacket[]{this};
    }

    public static class Builder {
        int sequenceId;
        String catalog;
        String schema;
        String table;
        String name;
        String columnAlias;
        byte serverCharsetId;
        long columnLength;
        DataType dataType;
        int precision = 0;
        int scale = 0;

        private Builder() {
        }

        public Builder sequenceId(int sequenceId) {
            this.sequenceId = sequenceId;
            return this;
        }

        public Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public Builder table(String table) {
            this.table = table;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder columnAlias(String columnAlias) {
            this.columnAlias = columnAlias;
            return this;
        }

        public Builder serverCharset(byte serverCharsetId) {
            this.serverCharsetId = serverCharsetId;
            return this;
        }

        public Builder columnLength(long columnLength) {
            this.columnLength = columnLength;
            return this;
        }

        public Builder dataType(DataType dataType) {
            assert (dataType != null);
            this.dataType = dataType;
            this.setColumnNumericInfo(dataType);
            return this;
        }

        private void setColumnNumericInfo(DataType dataType) {
            switch (dataType) {
                case BIGINT: {
                    this.setPrecisionAndScale(19, 0);
                    break;
                }
                case INTEGER: {
                    this.setPrecisionAndScale(10, 0);
                    break;
                }
                case DOUBLE: 
                case DECIMAL: {
                    this.setPrecisionAndScale(23, 10);
                    break;
                }
                case VARCHAR: {
                    this.setPrecisionAndScale(Integer.MAX_VALUE, 0);
                    break;
                }
                case DATE: 
                case TIME: 
                case DATETIME: {
                    this.setPrecisionAndScale(3, 0);
                    break;
                }
                case NULL: 
                case BOOLEAN: {
                    this.setPrecisionAndScale(0, 0);
                    break;
                }
            }
        }

        private void setPrecisionAndScale(int precision, int scale) {
            this.precision = precision;
            this.scale = scale;
        }

        public ColumnDefinitionPacket build() {
            return new ColumnDefinitionPacket(this);
        }
    }
}

