/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.jdbc.packet.server;

import kd.bos.flydb.jdbc.client.transfer.bytebuf.ReadableByteBuf;
import kd.bos.flydb.jdbc.packet.server.AbstractServerPacket;

public class ErrorResponsePacket
extends AbstractServerPacket {
    private final int errorNo;
    private final String message;

    private ErrorResponsePacket(Builder builder) {
        super(builder.sequenceId);
        this.errorNo = builder.errorNo;
        this.message = builder.message;
    }

    public int getErrorNo() {
        return this.errorNo;
    }

    public String getMessage() {
        return this.message;
    }

    public static ErrorResponsePacket decodeWithSkip(ReadableByteBuf readableByteBuf) {
        readableByteBuf.skip();
        return new Builder().sequenceId(readableByteBuf.readInt()).errorNo(readableByteBuf.readInt()).message(readableByteBuf.readStringNullEnd()).build();
    }

    public static ErrorResponsePacket decode(ReadableByteBuf readableByteBuf) {
        return new Builder().sequenceId(readableByteBuf.readInt()).errorNo(readableByteBuf.readInt()).message(readableByteBuf.readStringNullEnd()).build();
    }

    private static class Builder {
        private int sequenceId;
        private int errorNo;
        private String message;

        private Builder() {
        }

        public Builder sequenceId(int sequenceId) {
            this.sequenceId = sequenceId;
            return this;
        }

        public Builder errorNo(int errorNo) {
            this.errorNo = errorNo;
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public ErrorResponsePacket build() {
            return new ErrorResponsePacket(this);
        }
    }
}

