/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.jdbc.packet.server;

import java.util.Arrays;
import kd.bos.flydb.jdbc.client.transfer.bytebuf.ReadableByteBuf;
import kd.bos.flydb.jdbc.packet.ServerPacket;

public final class HandShakeAckPacket
implements ServerPacket {
    private String serverVersion;
    private final int serverStatus;
    private byte[] salt;
    private byte charsetId;
    private int sequenceId;

    private HandShakeAckPacket(String serverVersion, int serverStatus, byte[] salt, byte charsetId, int sequenceId) {
        this.serverVersion = serverVersion;
        this.serverStatus = serverStatus;
        this.salt = salt;
        this.charsetId = charsetId;
        this.sequenceId = sequenceId;
    }

    public static HandShakeAckPacket decode(ReadableByteBuf readableByteBuf) {
        String serverVersion = readableByteBuf.readStringNullEnd();
        int serverStatus = readableByteBuf.readInt();
        int len = readableByteBuf.readInt();
        byte[] salt = new byte[len];
        readableByteBuf.readBytes(salt);
        byte charsetId = readableByteBuf.readByte();
        byte sequenceId = readableByteBuf.readByte();
        return new HandShakeAckPacket(serverVersion, serverStatus, salt, charsetId, sequenceId);
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public int getServerStatus() {
        return this.serverStatus;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public byte getCharsetId() {
        return this.charsetId;
    }

    @Override
    public int getSequenceId() {
        return this.sequenceId;
    }

    public String toString() {
        return "HandShakeAckPacket{serverVersion='" + this.serverVersion + '\'' + ", serverStatus=" + this.serverStatus + ", salt=" + Arrays.toString(this.salt) + ", charsetId=" + this.charsetId + ", sequenceId=" + this.sequenceId + '}';
    }
}

