/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.jdbc.packet.server;

import kd.bos.flydb.jdbc.client.transfer.bytebuf.ReadableByteBuf;
import kd.bos.flydb.jdbc.packet.server.AbstractServerPacket;

public final class OkResponsePacket
extends AbstractServerPacket {
    private final long affectedRows;
    private final int serverStatus;
    private final int warnings;
    private final String connectionId;

    public OkResponsePacket(Builder builder) {
        super(builder.sequenceId);
        this.affectedRows = builder.affectedRows;
        this.serverStatus = builder.serverStatus;
        this.warnings = builder.warnings;
        this.connectionId = builder.connectionId;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public int getServerStatus() {
        return this.serverStatus;
    }

    public int getWarnings() {
        return this.warnings;
    }

    public long getAffectedRows() {
        return this.affectedRows;
    }

    private static Builder builder() {
        return new Builder();
    }

    public static OkResponsePacket decode(ReadableByteBuf readableByteBuf) {
        return OkResponsePacket.builder().sequenceId(readableByteBuf.readByte()).affectedRows(readableByteBuf.readLong()).statusFlags(readableByteBuf.readInt()).warnings(readableByteBuf.readInt()).connectionId(readableByteBuf.readStringNullEnd()).build();
    }

    private static class Builder {
        private int sequenceId;
        private long affectedRows;
        private int serverStatus;
        private int warnings;
        private String connectionId;

        private Builder() {
        }

        public Builder sequenceId(int sequenceId) {
            this.sequenceId = sequenceId;
            return this;
        }

        public Builder affectedRows(long affectedRows) {
            this.affectedRows = affectedRows;
            return this;
        }

        public Builder statusFlags(int statusFlags) {
            this.serverStatus = statusFlags;
            return this;
        }

        public Builder warnings(int warnings) {
            this.warnings = warnings;
            return this;
        }

        public Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public OkResponsePacket build() {
            return new OkResponsePacket(this);
        }
    }
}

