/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.jdbc.util;

import java.util.LinkedHashMap;
import java.util.Map;

public class LRUCacheMap<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 1645113899526137740L;
    private int cacheSize;
    private float loadFactor;

    public LRUCacheMap(int cacheSize) {
        this(cacheSize, 0.5f);
    }

    public LRUCacheMap(int cacheSize, float loadFactor) {
        super(cacheSize, loadFactor, true);
        this.cacheSize = cacheSize;
        this.loadFactor = loadFactor;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this.cacheSize;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public float getLoadFactor() {
        return this.loadFactor;
    }
}

