/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.jdbc.util;

import java.util.Arrays;
import kd.bos.flydb.jdbc.util.Parameter;

public class ParameterList {
    private Parameter[] elements;
    private int length;

    public ParameterList(int paramCount) {
        this.elements = new Parameter[paramCount];
        this.length = 0;
    }

    public void set(int index, Parameter element) {
        if (this.elements.length <= index) {
            this.grow(index + 1);
        }
        this.elements[index] = element;
        if (index >= this.length) {
            this.length = index + 1;
        }
    }

    public Parameter get(int index) {
        if (index >= this.length) {
            throw new ArrayIndexOutOfBoundsException("wrong index " + index + " length:" + this.length);
        }
        return this.elements[index];
    }

    public int size() {
        return this.length;
    }

    private void grow(int minLength) {
        int currLength = this.elements.length;
        int newLength = Math.max(currLength + (currLength >> 1), minLength);
        this.elements = Arrays.copyOf(this.elements, newLength);
    }
}

