/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.jdbc.util.encode;

import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import kd.bos.flydb.jdbc.client.transfer.Writer;
import kd.bos.flydb.jdbc.util.encode.Encoder;

public class DateEncoder
implements Encoder {
    public static final DateEncoder INSTANCE = new DateEncoder();
    private static final DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    @Override
    public void encodeText(Writer writer, Object value, Calendar calendar, Long length) throws IOException {
        Calendar cal = calendar == null ? Calendar.getInstance() : calendar;
        dtf.withZone(cal.getTimeZone().toZoneId());
        String dateStr = dtf.format(new Date(((java.sql.Date)value).getTime()).toInstant().atZone(cal.getTimeZone().toZoneId()).toLocalDate());
        writer.writeByte(39);
        writer.writeAscii(dateStr);
        writer.writeByte(39);
    }

    @Override
    public String toEncodeText(Object value, Calendar calendar, Long length) {
        Calendar cal = calendar == null ? Calendar.getInstance() : calendar;
        dtf.withZone(cal.getTimeZone().toZoneId());
        String dateStr = dtf.format(new Date(((java.sql.Date)value).getTime()).toInstant().atZone(cal.getTimeZone().toZoneId()).toLocalDate());
        StringBuilder ret = new StringBuilder();
        ret.append('\'');
        ret.append(dateStr);
        ret.append('\'');
        return ret.toString();
    }
}

