/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.jdbc.util.encode;

import java.io.IOException;
import java.sql.Time;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import kd.bos.flydb.jdbc.client.transfer.Writer;
import kd.bos.flydb.jdbc.util.encode.Encoder;

public class TimeEncoder
implements Encoder {
    public static final TimeEncoder INSTANCE = new TimeEncoder();
    private static final DateTimeFormatter dtf = DateTimeFormatter.ofPattern("HH:mm:ss");

    @Override
    public void encodeText(Writer writer, Object value, Calendar calendar, Long length) throws IOException {
        Calendar cal = calendar == null ? Calendar.getInstance() : calendar;
        dtf.withZone(cal.getTimeZone().toZoneId());
        String dateStr = dtf.format(Instant.ofEpochMilli(((Time)value).getTime()).atZone(cal.getTimeZone().toZoneId()).toLocalTime());
        writer.writeByte(39);
        writer.writeAscii(dateStr);
        writer.writeByte(39);
    }

    @Override
    public String toEncodeText(Object value, Calendar calendar, Long length) {
        Calendar cal = calendar == null ? Calendar.getInstance() : calendar;
        dtf.withZone(cal.getTimeZone().toZoneId());
        String dateStr = dtf.format(Instant.ofEpochMilli(((Time)value).getTime()).atZone(cal.getTimeZone().toZoneId()).toLocalTime());
        StringBuilder ret = new StringBuilder();
        ret.append('\'');
        ret.append(dateStr);
        ret.append('\'');
        return ret.toString();
    }
}

