/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.jdbc.util.encode;

import java.io.IOException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import kd.bos.flydb.jdbc.client.transfer.Writer;
import kd.bos.flydb.jdbc.util.encode.Encoder;

public class TimestampEncoder
implements Encoder {
    public static final TimestampEncoder INSTANCE = new TimestampEncoder();
    private static final DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    @Override
    public void encodeText(Writer writer, Object value, Calendar calendar, Long length) throws IOException {
        Calendar cal = calendar == null ? Calendar.getInstance() : calendar;
        dtf.withZone(cal.getTimeZone().toZoneId());
        String dateStr = dtf.format(LocalDateTime.ofInstant(((Timestamp)value).toInstant(), cal.getTimeZone().toZoneId()));
        writer.writeByte(39);
        writer.writeAscii(dateStr);
        writer.writeByte(39);
    }

    @Override
    public String toEncodeText(Object value, Calendar calendar, Long length) {
        Calendar cal = calendar == null ? Calendar.getInstance() : calendar;
        dtf.withZone(cal.getTimeZone().toZoneId());
        String dateStr = dtf.format(LocalDateTime.ofInstant(((Timestamp)value).toInstant(), cal.getTimeZone().toZoneId()));
        StringBuilder ret = new StringBuilder();
        ret.append('\'');
        ret.append(dateStr);
        ret.append('\'');
        return ret.toString();
    }
}

