/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.jdbc.util.parameter;

import java.io.IOException;
import kd.bos.flydb.jdbc.client.transfer.Writer;
import kd.bos.flydb.jdbc.util.encode.Encoder;

public class Parameter<T>
implements kd.bos.flydb.jdbc.util.Parameter {
    protected Encoder encoder;
    protected T value;
    protected Long length;
    public static final Parameter<?> NULL_PARAMETER = new Parameter<Object>(null, null);

    public Parameter(Encoder encoder, T value) {
        this.encoder = encoder;
        this.value = value;
        this.length = null;
    }

    public Parameter(Encoder encoder, T value, Long length) {
        this.encoder = encoder;
        this.value = value;
        this.length = length;
    }

    @Override
    public void encodeText(Writer writer) throws IOException {
        if (this.value == null) {
            writer.writeAscii("null");
        } else {
            this.encoder.encodeText(writer, this.value, null, this.length);
        }
    }

    @Override
    public String toEncodeText() {
        if (this.value == null) {
            return "null";
        }
        return this.encoder.toEncodeText(this.value, null, this.length);
    }

    @Override
    public boolean isNull() {
        return this.value == null;
    }
}

