/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.server;

import java.util.ArrayList;
import java.util.List;
import kd.bos.flydb.core.schema.metadata.SessionInfo;
import kd.bos.flydb.core.schema.metadata.SessionInfoProvider;
import kd.bos.flydb.server.core.CoreService;
import kd.bos.flydb.server.session2.Session;
import kd.bos.flydb.server.session2.SessionManager;
import kd.bos.flydb.server.session2.storage.SessionStateEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class SessionInfoProviderImpl
implements SessionInfoProvider {
    private static final Log log = LogFactory.getLog(SessionInfoProviderImpl.class);
    private final SessionManager sessionManager;

    public SessionInfoProviderImpl() {
        this.sessionManager = CoreService.getSessionManager();
    }

    public SessionInfoProviderImpl(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public List<SessionInfo> list() {
        List<Session> sessions = this.sessionManager.listSession();
        ArrayList<SessionInfo> infos = new ArrayList<SessionInfo>(sessions.size());
        for (Session session : sessions) {
            SessionInfo sessionInfo;
            if (session.isClosed() || (sessionInfo = this.convert(session.getState())) == null) continue;
            infos.add(sessionInfo);
        }
        return infos;
    }

    public SessionInfo get(String sessionId) {
        Session session = this.sessionManager.getSession(sessionId);
        if (session.isClosed()) {
            return null;
        }
        return this.convert(session.getState());
    }

    private SessionInfo convert(SessionStateEntity state) {
        if (state == null) {
            return null;
        }
        SessionInfo sessionInfo = new SessionInfo();
        sessionInfo.setId(state.getId());
        sessionInfo.setClientInfo(state.getHost());
        sessionInfo.setUserId(state.getUserId());
        sessionInfo.setUserName(state.getUser());
        sessionInfo.setSchema(state.getSchema());
        sessionInfo.setDatabase(state.getDb());
        sessionInfo.setTime(Long.valueOf(state.getTime()));
        sessionInfo.setState(state.getState());
        return sessionInfo;
    }
}

