/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.server.common;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import kd.bos.flydb.common.ServerConfig;
import kd.bos.flydb.common.ServerOption;
import kd.bos.flydb.common.config.Option;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public final class LogUtil {
    private static final Log logger = LogFactory.getLog((String)"FLY_DB");
    private static final String prefix = "@FlyDB_Error: ";
    private static final String prefixPart1 = "@FlyDB_Error: (part1) ";
    private static final String prefixPart2 = "@FlyDB_Error: (part2) ";

    private LogUtil() {
    }

    public static void logError(Throwable throwable) {
        LogUtil.logError(throwable, null, null);
    }

    public static void logError(Throwable throwable, String sql, Object[] param) {
        try {
            StringBuilder logBuilder = new StringBuilder();
            if (throwable != null) {
                logBuilder.append(throwable.getMessage());
            }
            if (sql != null) {
                logBuilder.append("\r\nsql:").append(sql);
                if (param != null && param.length > 0) {
                    logBuilder.append("\r\nparam:").append(LogUtil.paramToString(param));
                }
            }
            if (throwable == null || logBuilder.length() <= 4096) {
                logBuilder.insert(0, prefix);
                logger.error(logBuilder.toString(), throwable);
            } else {
                logBuilder.insert(0, prefixPart1);
                logger.error(logBuilder.toString());
                logger.error(prefixPart2 + throwable.getMessage(), throwable);
            }
        }
        catch (Throwable throwable1) {
            logger.error("@FlyDB_Error: Cause unexpected exception when logError: " + throwable1.getMessage(), throwable1);
            logger.error(throwable);
        }
    }

    private static String paramToString(Object[] param) {
        ArrayList<String> list = new ArrayList<String>(param.length);
        for (Object o : param) {
            list.add(LogUtil.paramToString(o));
        }
        String paramString = String.join((CharSequence)",", list);
        int maxParameterLength = ServerConfig.getSysConfiguration().getInt((Option)ServerOption.LogParamMaxLength);
        if (paramString.length() > maxParameterLength) {
            return paramString.substring(0, maxParameterLength) + "...";
        }
        return paramString;
    }

    private static String paramToString(Object p) {
        try {
            if (p == null) {
                return "null";
            }
            if (p instanceof String) {
                return "'" + p.toString() + "'";
            }
            if (p instanceof Integer) {
                return p.toString();
            }
            if (p instanceof Long) {
                return "L@" + p.toString();
            }
            if (p instanceof Float) {
                return "F@" + p.toString();
            }
            if (p instanceof Double) {
                return "D@" + p.toString();
            }
            if (p instanceof BigDecimal) {
                return "BD@" + ((BigDecimal)p).toPlainString();
            }
            if (p instanceof Date) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                return "DATE@" + dateFormat.format((Date)p);
            }
            if (p instanceof Time) {
                SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
                return "TIME@" + timeFormat.format((Time)p);
            }
            if (p instanceof Timestamp) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                return "TS@" + dateFormat.format((Timestamp)p);
            }
            return p.getClass().getName() + "@" + p.toString();
        }
        catch (Throwable throwable) {
            logger.error("@@error to print parameter", throwable);
            return "@@error";
        }
    }
}

