/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.server.core;

import kd.bos.flydb.core.interpreter.algox.DataSetOutputManager;
import kd.bos.flydb.core.interpreter.algox.DataSetOutputManagers;
import kd.bos.flydb.server.MasterQueryAPI;
import kd.bos.flydb.server.WorkerQueryAPI;
import kd.bos.flydb.server.core.MasterQueryAPIImpl;
import kd.bos.flydb.server.core.WorkerQueryAPIImpl;
import kd.bos.flydb.server.facade.WorkerAPI;
import kd.bos.flydb.server.facade.WorkerAPIImpl;
import kd.bos.flydb.server.facade.WorkerAPIRemoteDelegate;
import kd.bos.flydb.server.session2.LoginPermissionVerification;
import kd.bos.flydb.server.session2.LoginPermissionVerificationImpl;
import kd.bos.flydb.server.session2.SessionEventHandleService;
import kd.bos.flydb.server.session2.SessionEventHandleServiceImpl;
import kd.bos.flydb.server.session2.SessionManager;
import kd.bos.flydb.server.session2.SessionManagerBuilder;
import kd.bos.flydb.server.session2.storage.EntityStorage;
import kd.bos.flydb.server.session2.storage.SessionManagerStorage;
import kd.bos.flydb.server.session2.storage.redis.RedisEntityStorage;
import kd.bos.flydb.server.session2.storage.redis.SessionManagerStorageImpl;

public class CoreService {
    private static final EntityStorage entityStorage = new RedisEntityStorage();
    private static final SessionManagerStorage sessionManagerStorage = new SessionManagerStorageImpl();
    private static final LoginPermissionVerification loginPermissionVerification = new LoginPermissionVerificationImpl();
    private static final SessionEventHandleService sessionEventHandleService = new SessionEventHandleServiceImpl();
    private static final DataSetOutputManager dataSetOutputManager = DataSetOutputManagers.get();
    private static MasterQueryAPI masterQueryAPI;
    private static WorkerQueryAPI workerQueryAPI;
    private static SessionManager sessionManager;
    private static WorkerAPI workerAPI;

    public static synchronized void initMasterService() {
        workerAPI = new WorkerAPIRemoteDelegate();
        SessionManagerBuilder builder = new SessionManagerBuilder();
        builder.setWorkerAPISupplier(() -> workerAPI).setEntityStorageSupplier(() -> entityStorage).setSessionManagerStorageSupplier(() -> sessionManagerStorage).setLoginPermissionVerificationSupplier(() -> loginPermissionVerification).setSessionEventHandleService(() -> sessionEventHandleService);
        sessionManager = builder.build();
        masterQueryAPI = new MasterQueryAPIImpl(sessionManager);
    }

    public static synchronized void initWorkerService() {
        workerQueryAPI = new WorkerQueryAPIImpl(entityStorage, dataSetOutputManager);
        workerAPI = new WorkerAPIImpl(workerQueryAPI);
        SessionManagerBuilder builder = new SessionManagerBuilder();
        builder.setWorkerAPISupplier(() -> workerAPI).setEntityStorageSupplier(() -> entityStorage).setSessionManagerStorageSupplier(() -> sessionManagerStorage).setLoginPermissionVerificationSupplier(() -> loginPermissionVerification).setSessionEventHandleService(() -> sessionEventHandleService);
        sessionManager = builder.build();
    }

    public static EntityStorage getEntityStorage() {
        return entityStorage;
    }

    public static MasterQueryAPI getMasterQueryAPI() {
        return masterQueryAPI;
    }

    public static WorkerQueryAPI getWorkerQueryAPI() {
        return workerQueryAPI;
    }

    public static SessionManager getSessionManager() {
        return sessionManager;
    }

    public static WorkerAPI getWorkerAPI() {
        return workerAPI;
    }
}

