/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.server.core;

import kd.bos.flydb.common.ServerOption;
import kd.bos.flydb.common.config.Option;
import kd.bos.flydb.common.config.RedisConfiguration;
import kd.bos.flydb.common.exception.CoreException;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.server.ClientType;
import kd.bos.flydb.server.MasterQueryAPI;
import kd.bos.flydb.server.QueryContext;
import kd.bos.flydb.server.ResultInfo;
import kd.bos.flydb.server.SessionContext;
import kd.bos.flydb.server.common.LogUtil;
import kd.bos.flydb.server.session2.Session;
import kd.bos.flydb.server.session2.SessionManager;
import kd.bos.flydb.server.session2.storage.ResultSetEntity;
import kd.bos.flydb.server.session2.storage.StatementEntity;

public class MasterQueryAPIImpl
implements MasterQueryAPI {
    private final SessionManager sessionManager;

    public MasterQueryAPIImpl(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    @Override
    public String openSession(SessionContext context, String clientInfo, ClientType clientType) {
        try {
            return this.sessionManager.openSession(context, clientInfo, clientType).getId();
        }
        catch (Exception e) {
            LogUtil.logError(e);
            throw e;
        }
    }

    @Override
    public String prepare(String sessionId, String sql) {
        try {
            Session session = this.sessionManager.getSession(sessionId);
            session.checkClosed();
            return session.prepare(sql);
        }
        catch (Exception e) {
            LogUtil.logError(e, sql, null);
            throw e;
        }
    }

    @Override
    public ResultInfo executeQuery(QueryContext context, String stmtId, String sql, Object[] param) {
        try {
            StatementEntity statementEntity = this.sessionManager.getEntityStorage().get(stmtId, StatementEntity.class);
            if (statementEntity == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.ServerError_StatementClosed, (Object[])new Object[0]);
            }
            Session session = this.sessionManager.getSession(statementEntity.getSessionId());
            session.checkClosed();
            RedisConfiguration statementConfiguration = session.getStatementConfiguration(stmtId);
            if (context.getTimeout() > 0) {
                statementConfiguration.setInt((Option)ServerOption.QueryTimeout, context.getTimeout());
            }
            if (context.getFetchSize() > 0) {
                statementConfiguration.setInt((Option)ServerOption.FetchSize, context.getFetchSize());
            }
            return session.executeQuery(stmtId, sql, param);
        }
        catch (Exception e) {
            LogUtil.logError(e, sql, param);
            if (e instanceof CoreException) {
                throw e;
            }
            if (e.getCause() instanceof CoreException) {
                throw (CoreException)e.getCause();
            }
            if (e instanceof NullPointerException) {
                throw Exceptions.of((ErrorCode)ErrorCode.ServerError_UnexpectedException, (Object[])new Object[]{"Null pointer exception occurred, please obtain detailed information from the log"});
            }
            if (e.getCause() instanceof ClassCastException) {
                throw Exceptions.of((ErrorCode)ErrorCode.ServerError_UnexpectedException, (Object[])new Object[]{"ClassCastException occurred, please obtain detailed information from the log"});
            }
            if (e instanceof UnsupportedOperationException) {
                throw Exceptions.of((ErrorCode)ErrorCode.UnexpectedUnsupportedFeatureError, (Object[])new Object[]{e.getMessage()});
            }
            throw Exceptions.of((ErrorCode)ErrorCode.ServerError_UnexpectedException1, (Object[])new Object[0]);
        }
    }

    @Override
    public ResultInfo copy(String resultId) {
        try {
            ResultSetEntity resultSetEntity = this.sessionManager.getEntityStorage().get(resultId, ResultSetEntity.class);
            if (resultSetEntity == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.ServerError_ResultSetClosed, (Object[])new Object[0]);
            }
            Session session = this.sessionManager.getSession(resultSetEntity.getSessionId());
            session.checkClosed();
            return session.copy(resultId);
        }
        catch (Exception e) {
            LogUtil.logError(e);
            throw e;
        }
    }

    @Override
    public void closeStmt(String stmtId) {
        try {
            StatementEntity statementEntity = this.sessionManager.getEntityStorage().get(stmtId, StatementEntity.class);
            if (statementEntity == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.ServerError_StatementClosed, (Object[])new Object[0]);
            }
            Session session = this.sessionManager.getSession(statementEntity.getSessionId());
            session.checkClosed();
            session.closeStatement(stmtId);
        }
        catch (Exception e) {
            LogUtil.logError(e);
            throw e;
        }
    }

    @Override
    public void closeResult(String resultId) {
        try {
            ResultSetEntity resultSetEntity = this.sessionManager.getEntityStorage().get(resultId, ResultSetEntity.class);
            if (resultSetEntity == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.ServerError_ResultSetClosed, (Object[])new Object[0]);
            }
            Session session = this.sessionManager.getSession(resultSetEntity.getSessionId());
            session.checkClosed();
            session.closeResultSet(resultId);
        }
        catch (Exception e) {
            LogUtil.logError(e);
            throw e;
        }
    }

    @Override
    public void closeSession(String sessionId) {
        try {
            this.sessionManager.asyncCloseSession(sessionId);
        }
        catch (Exception e) {
            LogUtil.logError(e);
            throw e;
        }
    }

    @Override
    public String getSessionByResultId(String resultId) {
        try {
            ResultSetEntity resultSetEntity = this.sessionManager.getEntityStorage().get(resultId, ResultSetEntity.class);
            if (resultSetEntity == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.ServerError_ResultSetClosed, (Object[])new Object[0]);
            }
            return resultSetEntity.getSessionId();
        }
        catch (Exception e) {
            LogUtil.logError(e);
            throw e;
        }
    }
}

