/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.server.core;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.Row;
import kd.bos.flydb.common.exception.CoreException;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.ExceptionUtil;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.interpreter.algox.DataSetOutputManager;
import kd.bos.flydb.core.interpreter.algox.DataSetOutputManagers;
import kd.bos.flydb.core.interpreter.algox.DataSetReader;
import kd.bos.flydb.core.util.CloseableResource;
import kd.bos.flydb.server.ResultInfo;
import kd.bos.flydb.server.WorkerQueryAPI;
import kd.bos.flydb.server.common.LogUtil;
import kd.bos.flydb.server.session2.storage.EntityStorage;
import kd.bos.flydb.server.session2.storage.ResultSetEntity;

public class WorkerQueryAPIImpl
implements WorkerQueryAPI {
    private final EntityStorage entityStorage;
    private final DataSetOutputManager dataSetOutputManager;

    public WorkerQueryAPIImpl(EntityStorage entityStorage, DataSetOutputManager dataSetOutputManager) {
        this.entityStorage = entityStorage;
        this.dataSetOutputManager = dataSetOutputManager;
    }

    private void handleException(List<Throwable> exceptions) throws CoreException {
        if (exceptions.isEmpty()) {
            return;
        }
        LogUtil.logError(exceptions.get(0));
    }

    @Override
    public List<Row> fetch(String resultId, int limit, int offset) {
        try {
            ResultSetEntity resultSetEntity = this.entityStorage.get(resultId, ResultSetEntity.class);
            if (resultSetEntity == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.ResultSetNotExists, (Object[])new Object[0]);
            }
            String cursorId = resultSetEntity.getCursorId();
            return this.fetchByCursorId(cursorId, limit, offset);
        }
        catch (Exception e) {
            LogUtil.logError(e);
            throw ExceptionUtil.wrapAsException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResultInfo getResultInfo(String resultId) {
        try (CloseableResource resources = new CloseableResource(this::handleException);){
            ResultSetEntity resultSetEntity = this.entityStorage.get(resultId, ResultSetEntity.class);
            if (resultSetEntity == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.ResultSetNotExists, (Object[])new Object[0]);
            }
            String cursorId = resultSetEntity.getCursorId();
            DataSetReader reader = this.dataSetOutputManager.createReader(cursorId);
            resources.addCloseable((AutoCloseable)reader);
            ResultInfo resultInfo = new ResultInfo(resultId, reader.getRowMeta(), reader.getCount());
            return resultInfo;
        }
        catch (Exception e) {
            LogUtil.logError(e);
            throw ExceptionUtil.wrapAsException((Throwable)e);
        }
    }

    @Override
    public void closeCursor(String cursorId) {
        try {
            DataSetOutputManagers.get().deleteDataSet(cursorId);
        }
        catch (Exception e) {
            LogUtil.logError(e);
            throw ExceptionUtil.wrapAsException((Throwable)e);
        }
    }

    @Override
    public void batchCloseCursor(List<String> cursorIds) {
        if (cursorIds == null) {
            return;
        }
        ArrayList<Exception> exceptions = new ArrayList<Exception>(cursorIds.size());
        for (String cursorId : cursorIds) {
            try {
                this.closeCursor(cursorId);
            }
            catch (Exception exception) {
                exceptions.add(exception);
            }
        }
        if (!exceptions.isEmpty()) {
            Exception e = (Exception)exceptions.get(0);
            LogUtil.logError(e);
            throw ExceptionUtil.wrapAsException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Row> fetchByCursorId(String cursorId, int limit, int offset) {
        try (CloseableResource resources = new CloseableResource(this::handleException);){
            DataSetReader reader = this.dataSetOutputManager.createReader(cursorId);
            resources.addCloseable((AutoCloseable)reader);
            List list = reader.read(limit, offset);
            return list;
        }
        catch (Exception e) {
            LogUtil.logError(e);
            throw ExceptionUtil.wrapAsException((Throwable)e);
        }
    }
}

