/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.server.core.session;

import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.flydb.common.SessionContextOption;
import kd.bos.flydb.common.config.Option;
import kd.bos.flydb.core.ExecuteParams;
import kd.bos.flydb.core.ExecutorSupplier;
import kd.bos.flydb.core.interpreter.Executor;
import kd.bos.flydb.server.core.CoreService;
import kd.bos.flydb.server.session2.Session;
import kd.bos.flydb.server.session2.SessionManager;
import kd.bos.flydb.server.session2.SessionStateUpdateSchemaEvent;

public class UseSchemaExecutorSupplier
implements ExecutorSupplier {
    public static final UseSchemaExecutorSupplier instance = new UseSchemaExecutorSupplier();
    private final SessionManager sessionManager;

    public UseSchemaExecutorSupplier() {
        this.sessionManager = CoreService.getSessionManager();
    }

    public UseSchemaExecutorSupplier(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public Executor get(ExecuteParams params) {
        return () -> {
            Session session = this.sessionManager.getSession(params.getSessionId());
            session.getSessionConfiguration().setString((Option)SessionContextOption.Database, params.getTargetDatabase());
            session.getSessionConfiguration().setString((Option)SessionContextOption.Schema, params.getTargetSchema());
            SessionStateUpdateSchemaEvent event = new SessionStateUpdateSchemaEvent(session, System.currentTimeMillis(), params.getTargetSchema());
            this.sessionManager.getEventHandleService().submit(event);
            return new Executor.ExecuteResult(new RowMeta(new Field[0]));
        };
    }
}

