/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.server.facade;

import java.util.List;
import kd.bos.algo.Row;
import kd.bos.flydb.common.exception.CoreException;
import kd.bos.flydb.server.ClientType;
import kd.bos.flydb.server.MasterQueryAPI;
import kd.bos.flydb.server.QueryContext;
import kd.bos.flydb.server.ResultInfo;
import kd.bos.flydb.server.SessionContext;
import kd.bos.flydb.server.core.CoreService;
import kd.bos.flydb.server.facade.DriverServerAPI;
import kd.bos.flydb.server.facade.WorkerAPI;

public class DriverServerAPIImpl
implements DriverServerAPI {
    private final MasterQueryAPI masterQueryAPI;

    public DriverServerAPIImpl() {
        this.masterQueryAPI = CoreService.getMasterQueryAPI();
    }

    public DriverServerAPIImpl(MasterQueryAPI masterQueryAPI) {
        this.masterQueryAPI = masterQueryAPI;
    }

    @Override
    public String openSession(SessionContext sessionContext, String clientInfo) throws CoreException {
        return this.masterQueryAPI.openSession(sessionContext, clientInfo, ClientType.JDBC_CLIENT);
    }

    @Override
    public String prepare(String sessionId, String sql) throws CoreException {
        return this.masterQueryAPI.prepare(sessionId, sql);
    }

    @Override
    public ResultInfo executeQuery(QueryContext context, String stmtId, String sql, Object[] param) throws CoreException {
        return this.masterQueryAPI.executeQuery(context, stmtId, sql, param);
    }

    @Override
    public List<Row> fetch(String resultId, int limit, int offset) throws CoreException {
        return WorkerAPI.getRemote().fetch(resultId, limit, offset);
    }

    @Override
    public void closeResult(String resultId) throws CoreException {
        this.masterQueryAPI.closeResult(resultId);
    }

    @Override
    public void closeStatement(String statementId) throws CoreException {
        this.masterQueryAPI.closeStmt(statementId);
    }

    @Override
    public void closeSession(String sessionId) throws CoreException {
        this.masterQueryAPI.closeSession(sessionId);
    }
}

