/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.server.facade;

import kd.bos.flydb.common.ServerConfig;
import kd.bos.flydb.common.ServerOption;
import kd.bos.flydb.common.config.Option;
import kd.bos.flydb.common.exception.CoreException;
import kd.bos.flydb.common.util.RedisSet;
import kd.bos.flydb.server.ClientType;
import kd.bos.flydb.server.MasterQueryAPI;
import kd.bos.flydb.server.QueryContext;
import kd.bos.flydb.server.ResultInfo;
import kd.bos.flydb.server.SessionContext;
import kd.bos.flydb.server.core.CoreService;
import kd.bos.flydb.server.facade.MasterAPI;
import kd.bos.flydb.server.facade.MasterQueryContext;

public class MasterAPIImpl
implements MasterAPI {
    private final MasterQueryAPI masterQueryAPI;

    public MasterAPIImpl() {
        this.masterQueryAPI = CoreService.getMasterQueryAPI();
    }

    public MasterAPIImpl(MasterQueryAPI masterQueryAPI) {
        this.masterQueryAPI = masterQueryAPI;
    }

    @Override
    public boolean checkServerState() {
        return true;
    }

    @Override
    public ResultInfo executeQuery(MasterQueryContext context, String sql, Object[] param) throws CoreException {
        SessionContext sessionContext = new SessionContext(context.getDatabase(), context.getSchema(), context.getTenantId(), context.getAccountId(), context.getUserId());
        QueryContext queryContext = new QueryContext(context.getTimeout(), context.getFetchSize());
        String sessionId = this.masterQueryAPI.openSession(sessionContext, "cosmic-rpc", ClientType.SUPER_QUERY);
        String stmtId = this.masterQueryAPI.prepare(sessionId, sql);
        ResultInfo resultInfo = this.masterQueryAPI.executeQuery(queryContext, stmtId, sql, param);
        RedisSet resultCounter = this.getResultCounter(sessionId);
        resultCounter.add(resultInfo.getResultId());
        resultCounter.expire((long)ServerConfig.getSysConfiguration().getInt((Option)ServerOption.SessionTimeout).intValue());
        return resultInfo;
    }

    @Override
    public ResultInfo copy(String resultId) throws CoreException {
        ResultInfo resultInfo = this.masterQueryAPI.copy(resultId);
        String sessionId = this.masterQueryAPI.getSessionByResultId(resultId);
        RedisSet resultCounter = this.getResultCounter(sessionId);
        resultCounter.add(resultInfo.getResultId());
        resultCounter.expire((long)ServerConfig.getSysConfiguration().getInt((Option)ServerOption.SessionTimeout).intValue());
        return resultInfo;
    }

    @Override
    public void close(String resultId) throws CoreException {
        String sessionId = this.masterQueryAPI.getSessionByResultId(resultId);
        this.masterQueryAPI.closeResult(resultId);
        RedisSet counter = this.getResultCounter(sessionId);
        counter.remove(resultId);
        if (counter.list().isEmpty()) {
            this.closeSession(sessionId);
            this.getResultCounter(sessionId).release();
        }
    }

    @Override
    public void closeSession(String sessionId) throws CoreException {
        this.masterQueryAPI.closeSession(sessionId);
    }

    private RedisSet getResultCounter(String sessionId) {
        return new RedisSet(this.getClass().getName(), "resultCounter", sessionId);
    }
}

