/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.server.http.action;

import java.io.OutputStream;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.server.http.codec.decode.ReadableByteBuf;
import kd.bos.flydb.server.http.codec.decode.ReadableInputStream;
import kd.bos.flydb.server.http.codec.encode.impl.PacketWriter;
import kd.bos.flydb.server.http.packet.ServerPacket;
import kd.bos.flydb.server.http.packet.ServerPacketFactory;
import kd.bos.flydb.server.http.util.ErrorResponsePackets;
import kd.bos.flydb.server.http.util.FlyWebLogger;
import kd.bos.flydb.server.http.util.ResponseUtil;
import kd.bos.flydb.server.http.util.ThreadManageWrapper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.DisCardUtil;

public class FlyWebAction
implements FlyWebLogger {
    private static final Log LOG = LogFactory.getLog(FlyWebAction.class);

    public void authorize(HttpServletRequest request, HttpServletResponse response) {
        DisCardUtil.discard();
    }

    public void handlePacket(HttpServletRequest request, HttpServletResponse response) {
        if (!this.isPostRequestMethod(request)) {
            ResponseUtil.serverError(response, "FlyDBWeb only allow to use 'POST' request.", null, 1, ErrorCode.ServerError_UnexpectedException, "Request type error");
            return;
        }
        this.info(String.format("FlyDBWeb handle packet request url='%s'.", request.getRequestURI()));
        try (ServletInputStream inputStream = request.getInputStream();
             ServletOutputStream outputStream = response.getOutputStream();){
            ReadableInputStream readableInputStream = new ReadableInputStream(inputStream);
            ReadableByteBuf readableByteBuf = readableInputStream.decode(true);
            byte commandCode = readableByteBuf.readByte();
            ThreadManageWrapper threadManageWrapper = () -> {
                this.info("FlyDBWeb handle packet start.");
                int sequenceId = readableInputStream.getSequenceId();
                ServerPacket serverPacket = ServerPacketFactory.get().lookup(commandCode, sequenceId, readableByteBuf);
                if (inputStream.available() > 0 || serverPacket == null) {
                    serverPacket = ErrorResponsePackets.newErrorPacket(++sequenceId, ErrorCode.ServerError_PacketDecodeError, serverPacket);
                }
                PacketWriter writer = new PacketWriter((OutputStream)outputStream, serverPacket.getSequenceId());
                serverPacket.encode(writer);
                writer.flush();
                this.info("FlyDBWeb handle packet end.");
            };
            threadManageWrapper.wrap();
        }
        catch (Exception e) {
            ResponseUtil.serverError(response, "FlyDBWeb cause an exception when handle packet, msg: " + e.getMessage(), e, 1, ErrorCode.ServerError_UnexpectedException, e.getMessage());
        }
    }

    private boolean isPostRequestMethod(HttpServletRequest request) {
        return "POST".equalsIgnoreCase(request.getMethod());
    }
}

