/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.server.http.codec.decode;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletInputStream;
import kd.bos.flydb.server.http.codec.decode.ReadableByteBuf;
import kd.bos.flydb.server.http.codec.decode.impl.StandardReadableByteBuf;

public class ReadableInputStream {
    private static final int REUSABLE_BUFFER_LENGTH = 1024;
    private static final int MAX_PACKET_SIZE = 0xFFFFFF;
    private final byte[] header = new byte[4];
    private final byte[] reusableArray = new byte[1024];
    private final InputStream inputStream;
    private int sequenceId;

    public ReadableInputStream(ServletInputStream inputStream) {
        this.inputStream = inputStream;
    }

    public ReadableByteBuf decode(boolean reUsable) throws IOException {
        int count;
        int count2;
        int remaining = 4;
        int off = 0;
        do {
            if ((count2 = this.inputStream.read(this.header, off, remaining)) < 0) {
                throw new EOFException("unexpected end of stream, read " + off + " bytes from 4 (socket was closed by server)");
            }
            off += count2;
        } while ((remaining -= count2) > 0);
        int lastPacketLength = (this.header[0] & 0xFF) + ((this.header[1] & 0xFF) << 8) + ((this.header[2] & 0xFF) << 16);
        this.sequenceId = this.header[3];
        byte[] rawBytes = reUsable && lastPacketLength < 1024 ? this.reusableArray : new byte[lastPacketLength];
        remaining = lastPacketLength;
        off = 0;
        do {
            if ((count = this.inputStream.read(rawBytes, off, remaining)) < 0) {
                throw new EOFException("unexpected end of stream, read " + (lastPacketLength - remaining) + " bytes from " + lastPacketLength + " (socket was closed by server)");
            }
            off += count;
        } while ((remaining -= count) > 0);
        if (lastPacketLength == 0xFFFFFF) {
            int packetLength;
            do {
                int count3;
                int count4;
                remaining = 4;
                off = 0;
                do {
                    if ((count4 = this.inputStream.read(this.header, off, remaining)) < 0) {
                        throw new EOFException("unexpected end of stream, read " + off + " bytes from 4");
                    }
                    off += count4;
                } while ((remaining -= count4) > 0);
                packetLength = (this.header[0] & 0xFF) + ((this.header[1] & 0xFF) << 8) + ((this.header[2] & 0xFF) << 16);
                this.sequenceId = this.header[3];
                int currentbufLength = rawBytes.length;
                byte[] newRawBytes = new byte[currentbufLength + packetLength];
                System.arraycopy(rawBytes, 0, newRawBytes, 0, currentbufLength);
                rawBytes = newRawBytes;
                remaining = packetLength;
                off = currentbufLength;
                do {
                    if ((count3 = this.inputStream.read(rawBytes, off, remaining)) < 0) {
                        throw new EOFException("unexpected end of stream, read " + (packetLength - remaining) + " bytes from " + packetLength);
                    }
                    off += count3;
                } while ((remaining -= count3) > 0);
                lastPacketLength += packetLength;
            } while (packetLength == 0xFFFFFF);
        }
        return new StandardReadableByteBuf(rawBytes, lastPacketLength);
    }

    public int getSequenceId() {
        return this.sequenceId;
    }
}

