/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.server.http.codec.util;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kd.bos.flydb.server.http.codec.decode.ReadableByteBuf;
import kd.bos.flydb.server.http.codec.encode.Writer;

public class CodecUtils {
    private CodecUtils() {
    }

    public static String readNullTerminateString(ReadableByteBuf readableByteBuf, Charset charset) {
        byte[] bytes = readableByteBuf.readBytesNullEnd();
        return new String(bytes, charset);
    }

    public static void writeNullTerminateString(Writer writer, String str) throws IOException {
        writer.writeString(str);
        writer.writeNull();
    }

    public static void writeLengthEncodedString(Writer writer, String str) throws IOException {
        if (str == null) {
            writer.writeByte(251);
        } else {
            byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
            int length = bytes.length;
            writer.writeLength(length);
            writer.writeBytes(bytes);
        }
    }
}

