/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.server.http.filter;

import java.io.IOException;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.util.JedisClientResource;
import kd.bos.flydb.server.http.codec.decode.ReadableByteBuf;
import kd.bos.flydb.server.http.codec.decode.ReadableInputStream;
import kd.bos.flydb.server.http.codec.encode.impl.PacketWriter;
import kd.bos.flydb.server.http.filter.ClusterAuthKey;
import kd.bos.flydb.server.http.packet.ServerPacket;
import kd.bos.flydb.server.http.packet.common.ClientCommand;
import kd.bos.flydb.server.http.packet.handler.AckResponseServerHandler;
import kd.bos.flydb.server.http.packet.handler.AckServerHandler;
import kd.bos.flydb.server.http.util.ErrorResponsePackets;
import kd.bos.flydb.server.http.util.FlyWebLogger;
import kd.bos.flydb.server.http.util.ResponseUtil;
import kd.bos.flydb.server.http.util.ThreadManageWrapper;
import kd.bos.login.utils.LoginUtils;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;
import kd.bos.session.SessionKeys;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.RevProxyUtil;
import org.apache.commons.lang3.StringUtils;

public class AuthFilter
implements Filter,
FlyWebLogger {
    private static byte[] salt = new byte[21];

    public void init(FilterConfig filterConfig) throws ServletException {
        new SecureRandom().nextBytes(salt);
        try (JedisClientResource resource = JedisClientResource.create();){
            byte[] clusterKeyBytes = ClusterAuthKey.clusterKeyBytes();
            if (resource.getClient().setnx(clusterKeyBytes, salt) != 1L) {
                salt = resource.getClient().get(clusterKeyBytes);
                this.refreshSaltExpireTime();
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private void refreshSaltExpireTime() {
        try (JedisClientResource resource = JedisClientResource.create();){
            byte[] clusterKeyBytes = ClusterAuthKey.clusterKeyBytes();
            resource.getClient().expire(clusterKeyBytes, TimeUnit.HOURS.toSeconds(8L));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void destroy() {
        try (JedisClientResource resource = JedisClientResource.create();){
            byte[] clusterKeyBytes = ClusterAuthKey.clusterKeyBytes();
            resource.getClient().del(clusterKeyBytes);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        this.refreshSaltExpireTime();
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        String requestURI = httpServletRequest.getRequestURI();
        this.info(String.format("FlyDBWeb request url is '%s', traceId=%s", requestURI, TraceIdUtil.getCurrentTraceIdString()));
        if (this.isFlyWebRequestUri(requestURI)) {
            String globalSessionId = this.getFromCookies(httpServletRequest);
            this.info(String.format("FlyDBWeb globalSessionId='%s'", globalSessionId));
            if (globalSessionId == null) {
                if (requestURI.endsWith("/flyweb/authorize.do")) {
                    String method = httpServletRequest.getMethod();
                    if (!"POST".equalsIgnoreCase(method)) {
                        ResponseUtil.serverError(httpServletResponse, "FlyDBWeb only allow to use 'POST' request.", null, 1, ErrorCode.ServerError_UnexpectedException, "Request type error");
                        return;
                    }
                    try (ServletInputStream inputStream = httpServletRequest.getInputStream();
                         ServletOutputStream outputStream = httpServletResponse.getOutputStream();){
                        ReadableInputStream readableInputStream = new ReadableInputStream(inputStream);
                        ReadableByteBuf readableByteBuf = readableInputStream.decode(true);
                        byte commandCode = readableByteBuf.readByte();
                        ThreadManageWrapper threadManageWrapper = () -> {
                            this.info("FlyDBWeb authorize start.");
                            Optional<ClientCommand> command = ClientCommand.findClientCommandType(commandCode);
                            int sequenceId = readableInputStream.getSequenceId();
                            if (!command.isPresent()) {
                                throw new UnsupportedOperationException("Unknown client commandCode :" + commandCode);
                            }
                            ServerPacket serverPacket = null;
                            if (command.get() == ClientCommand.COM_ACK) {
                                serverPacket = new AckServerHandler(salt, sequenceId).handle();
                            } else if (command.get() == ClientCommand.COM_ACK_RESPONSE) {
                                serverPacket = new AckResponseServerHandler(readableByteBuf, sequenceId, httpServletRequest, httpServletResponse, salt).handle();
                            }
                            if (inputStream.available() > 0 || serverPacket == null) {
                                serverPacket = ErrorResponsePackets.newErrorPacket(++sequenceId, ErrorCode.ServerError_PacketDecodeError, serverPacket);
                            }
                            PacketWriter writer = new PacketWriter((OutputStream)outputStream, serverPacket.getSequenceId());
                            serverPacket.encode(writer);
                            writer.flush();
                            this.info("FlyDBWeb authorize end.");
                        };
                        threadManageWrapper.wrap();
                    }
                    catch (Exception e) {
                        ResponseUtil.serverError(httpServletResponse, "FlyDBWeb cause an exception when verifying auth, msg: " + e.getMessage(), e, 1, ErrorCode.ServerError_UnexpectedException, e.getMessage());
                    }
                } else {
                    List<String> cookieNameList = this.dumpCookieNameList(httpServletRequest);
                    ResponseUtil.serverError(httpServletResponse, "FlyDBWeb can not get global session id from cookies, target cookie name is: " + SessionKeys.getGlobalCookieSessionkey((String)RevProxyUtil.getTenantCode((HttpServletRequest)httpServletRequest)) + " , cookies dump is : " + String.join((CharSequence)",", cookieNameList), null, 1, ErrorCode.ServerError_UnexpectedException, "Can't get session id");
                }
            } else if (this.verifyCookieSession(httpServletRequest, globalSessionId)) {
                this.info("FlyDBWeb start doFilter to handle packet.");
                filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                this.info("FlyDBWeb end doFilter to handle packet.");
            } else {
                ResponseUtil.serverError(httpServletResponse, "FlyDBWeb session valid error, globalSessionId is: " + globalSessionId, null, 1, ErrorCode.ServerError_ConnectionInvalid, new Object[0]);
            }
        } else {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
    }

    private boolean isFlyWebRequestUri(String requestURI) {
        return requestURI.endsWith("/flyweb/authorize.do") || requestURI.endsWith("/flyweb/handlePacket.do") || requestURI.indexOf("/flyweb/") != -1;
    }

    private boolean verifyCookieSession(HttpServletRequest httpServletRequest, String globalSessionId) {
        if (kd.bos.util.StringUtils.isEmpty((String)globalSessionId)) {
            return false;
        }
        String reqTenantNo = RevProxyUtil.getTenantCode((HttpServletRequest)httpServletRequest);
        if (!kd.bos.util.StringUtils.isEmpty((String)reqTenantNo)) {
            SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO((String)globalSessionId);
            String sessionTenantId = sessionDAO.getAttribute("tenantId");
            return reqTenantNo.equalsIgnoreCase(sessionTenantId);
        }
        return true;
    }

    private String getAccountIdFromRequest(HttpServletRequest request) {
        String accountIdParameter = LoginUtils.getParamerter((HttpServletRequest)request, (String)"kdcdc");
        if (StringUtils.isEmpty((CharSequence)accountIdParameter)) {
            accountIdParameter = LoginUtils.getParamerter((HttpServletRequest)request, (String)"accountId");
        }
        if (StringUtils.isEmpty((CharSequence)accountIdParameter)) {
            accountIdParameter = LoginUtils.getParamerter((HttpServletRequest)request, (String)StringUtils.lowerCase((String)"accountId"));
        }
        return accountIdParameter;
    }

    private String getFromCookies(HttpServletRequest request) {
        String accountId = this.getAccountIdFromRequest(request);
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        if (accountId != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(SessionKeys.getGlobalCookieSessionkey((String)RevProxyUtil.getTenantCode((HttpServletRequest)request), (String)accountId))) continue;
                return cookie.getValue();
            }
        }
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equals(SessionKeys.getGlobalCookieSessionkey((String)RevProxyUtil.getTenantCode((HttpServletRequest)request)))) continue;
            return cookie.getValue();
        }
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equals(SessionKeys.getOldGlobalCookieSessionkey())) continue;
            return cookie.getValue();
        }
        return null;
    }

    private List<String> dumpCookieNameList(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null || cookies.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> cookieNameList = new ArrayList<String>(cookies.length);
        for (Cookie cookie : cookies) {
            cookieNameList.add(cookie.getName());
        }
        return cookieNameList;
    }
}

