/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.server.http.packet;

import java.util.Optional;
import kd.bos.flydb.server.http.codec.decode.ReadableByteBuf;
import kd.bos.flydb.server.http.packet.ServerPacket;
import kd.bos.flydb.server.http.packet.common.ClientCommand;
import kd.bos.flydb.server.http.packet.handler.FetchCloseServerHandler;
import kd.bos.flydb.server.http.packet.handler.FetchPacketServerHandler;
import kd.bos.flydb.server.http.packet.handler.QueryPacketServerHandler;
import kd.bos.flydb.server.http.packet.handler.QuitPacketServerHandler;
import kd.bos.flydb.server.http.packet.handler.StatementCloseServerHandler;

public final class ServerPacketFactory {
    private static final ServerPacketFactory instance = new ServerPacketFactory();

    private ServerPacketFactory() {
    }

    public static ServerPacketFactory get() {
        return instance;
    }

    public ServerPacket lookup(byte commandCode, int sequenceId, ReadableByteBuf readableByteBuf) {
        Optional<ClientCommand> command = ClientCommand.findClientCommandType(commandCode);
        if (!command.isPresent()) {
            throw new UnsupportedOperationException("Unknown client commandCode :" + commandCode);
        }
        switch (command.get()) {
            case COM_QUERY: {
                return new QueryPacketServerHandler(readableByteBuf, sequenceId).handle();
            }
            case COM_STMT_FETCH: {
                return new FetchPacketServerHandler(readableByteBuf).handle();
            }
            case COM_RESULT_CLOSE: {
                return new FetchCloseServerHandler(readableByteBuf).handle();
            }
            case COM_STMT_CLOSE: {
                return new StatementCloseServerHandler(readableByteBuf).handle();
            }
            case COM_QUIT: {
                return new QuitPacketServerHandler(readableByteBuf).handle();
            }
        }
        throw new RuntimeException("Unhandled command packet.");
    }
}

