/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.server.http.packet.client;

import java.nio.charset.Charset;
import kd.bos.flydb.server.http.codec.decode.ReadableByteBuf;
import kd.bos.flydb.server.http.packet.ClientPacket;
import kd.bos.flydb.server.http.packet.common.ServerCharset;

public class HandShakeResponsePacket
implements ClientPacket {
    private byte exchangeCharset;
    private int sequenceId;
    private String username;
    private String auth;
    private String account;
    private String database;
    private String schema;

    public HandShakeResponsePacket(Builder builder) {
        this.exchangeCharset = builder.exchangeCharset;
        this.sequenceId = builder.sequenceId;
        this.username = builder.username;
        this.auth = builder.auth;
        this.account = builder.account;
        this.database = builder.database;
        this.schema = builder.schema;
    }

    public static Builder create() {
        return new Builder();
    }

    public byte getExchangeCharset() {
        return this.exchangeCharset;
    }

    @Override
    public int getSequenceId() {
        return this.sequenceId;
    }

    public String getUsername() {
        return this.username;
    }

    public String getAuth() {
        return this.auth;
    }

    public String getAccount() {
        return this.account;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getSchema() {
        return this.schema;
    }

    public static HandShakeResponsePacket decode(ReadableByteBuf readableByteBuf, byte[] salt) {
        Builder handShakeResponseBuilder = HandShakeResponsePacket.create();
        byte charsetId = readableByteBuf.readByte();
        handShakeResponseBuilder.exchangeCharset(charsetId);
        Charset charset = ServerCharset.getCharsetById(charsetId);
        handShakeResponseBuilder.sequenceId(readableByteBuf.readInt());
        byte[] userData = readableByteBuf.readBytesNullEnd();
        handShakeResponseBuilder.userName(new String(userData, charset));
        int len = readableByteBuf.readLength();
        byte[] authData = new byte[len];
        readableByteBuf.readBytes(authData);
        handShakeResponseBuilder.auth(new String(HandShakeResponsePacket.decrypt(authData, salt), charset));
        handShakeResponseBuilder.account(readableByteBuf.readStringNullEnd());
        String database = readableByteBuf.readStringNullEnd();
        String schema = readableByteBuf.readStringNullEnd();
        handShakeResponseBuilder.database(HandShakeResponsePacket.idNullOrEmpty(database) ? "cosmic_db" : database);
        handShakeResponseBuilder.schema(schema);
        return handShakeResponseBuilder.build();
    }

    private static byte[] decrypt(byte[] authData, byte[] salt) {
        if (authData.length <= salt.length) {
            for (int i = 0; i < authData.length; ++i) {
                int n = i;
                authData[n] = (byte)(authData[n] ^ salt[i]);
            }
        } else {
            for (int i = 0; i < salt.length; ++i) {
                int n = i;
                authData[n] = (byte)(authData[n] ^ salt[i]);
            }
        }
        return authData;
    }

    private static boolean idNullOrEmpty(String val) {
        return val == null || val.isEmpty();
    }

    public static class Builder {
        public byte exchangeCharset;
        private int sequenceId;
        private String username;
        private String auth;
        private String account;
        private String database;
        private String schema;

        private Builder() {
        }

        public Builder exchangeCharset(byte exchangeCharset) {
            this.exchangeCharset = exchangeCharset;
            return this;
        }

        public Builder sequenceId(int sequenceId) {
            this.sequenceId = sequenceId;
            return this;
        }

        public Builder userName(String username) {
            this.username = username;
            return this;
        }

        public Builder auth(String auth) {
            this.auth = auth;
            return this;
        }

        public Builder account(String account) {
            this.account = account;
            return this;
        }

        public Builder database(String database) {
            this.database = database;
            return this;
        }

        public Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public HandShakeResponsePacket build() {
            return new HandShakeResponsePacket(this);
        }
    }
}

