/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.server.http.packet.common;

public enum DataType {
    INTEGER(3),
    DOUBLE(5),
    NULL(6),
    BIGINT(8),
    DATE(10),
    TIME(11),
    DATETIME(12),
    VARCHAR(15),
    BOOLEAN(244),
    DECIMAL(246);

    static final DataType[] typeMap;
    private final int type;

    private DataType(int type) {
        this.type = type;
    }

    public static DataType convertToDataType(kd.bos.algo.DataType dataType) {
        if (kd.bos.algo.DataType.BooleanType.equals((Object)dataType)) {
            return BOOLEAN;
        }
        if (kd.bos.algo.DataType.BigDecimalType.equals((Object)dataType)) {
            return DECIMAL;
        }
        if (kd.bos.algo.DataType.DateType.equals((Object)dataType)) {
            return DATE;
        }
        if (kd.bos.algo.DataType.DoubleType.equals((Object)dataType)) {
            return DOUBLE;
        }
        if (kd.bos.algo.DataType.IntegerType.equals((Object)dataType)) {
            return INTEGER;
        }
        if (kd.bos.algo.DataType.LongType.equals((Object)dataType)) {
            return BIGINT;
        }
        if (kd.bos.algo.DataType.NullType.equals((Object)dataType)) {
            return NULL;
        }
        if (kd.bos.algo.DataType.StringType.equals((Object)dataType)) {
            return VARCHAR;
        }
        if (kd.bos.algo.DataType.TimestampType.equals((Object)dataType)) {
            return DATETIME;
        }
        throw new UnsupportedOperationException("unsupported dataTypeId=" + dataType);
    }

    public int get() {
        return this.type;
    }

    public static DataType of(int typeValue) {
        return typeMap[typeValue];
    }

    static {
        typeMap = new DataType[256];
        DataType[] dataTypeArray = DataType.values();
        int n = dataTypeArray.length;
        for (int i = 0; i < n; ++i) {
            DataType v;
            DataType.typeMap[v.type] = v = dataTypeArray[i];
        }
    }
}

