/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.server.http.packet.handler;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.context.RequestContext;
import kd.bos.dc.api.model.Account;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.manager.SuperQueryService;
import kd.bos.flydb.server.SessionContext;
import kd.bos.flydb.server.facade.DriverServerAPI;
import kd.bos.flydb.server.http.auth.CheckAuth;
import kd.bos.flydb.server.http.auth.CheckAuthDecider;
import kd.bos.flydb.server.http.codec.decode.ReadableByteBuf;
import kd.bos.flydb.server.http.packet.ServerPacket;
import kd.bos.flydb.server.http.packet.client.HandShakeResponsePacket;
import kd.bos.flydb.server.http.packet.handler.ServerHandler;
import kd.bos.flydb.server.http.packet.server.LoginResponsePacket;
import kd.bos.flydb.server.http.util.BindingRequestContextToThread;
import kd.bos.flydb.server.http.util.DatabaseLookupUtils;
import kd.bos.flydb.server.http.util.ErrorResponsePackets;
import kd.bos.session.SessionInfo;
import kd.bos.session.SessionManager;
import kd.bos.util.NetAddressUtils;

public class AckResponseServerHandler
implements ServerHandler {
    private final ReadableByteBuf readableByteBuf;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private int sequenceId;
    private byte[] salt;

    public AckResponseServerHandler(ReadableByteBuf readableByteBuf, int sequenceId, HttpServletRequest request, HttpServletResponse response, byte[] salt) {
        this.readableByteBuf = readableByteBuf;
        this.sequenceId = sequenceId;
        this.request = request;
        this.response = response;
        this.salt = salt;
    }

    @Override
    public ServerPacket handle() {
        try {
            HandShakeResponsePacket handShakeResponsePacket = HandShakeResponsePacket.decode(this.readableByteBuf, this.salt);
            String username = handShakeResponsePacket.getUsername();
            String auth = handShakeResponsePacket.getAuth();
            String accountNum = handShakeResponsePacket.getAccount();
            String database = handShakeResponsePacket.getDatabase();
            String schema = handShakeResponsePacket.getSchema();
            String host = NetAddressUtils.getRemoteHost((HttpServletRequest)this.request);
            Account account = DatabaseLookupUtils.findAccountId(accountNum);
            if (account == null) {
                return ErrorResponsePackets.newErrorPacket(++this.sequenceId, ErrorCode.ServerError_AccountNotExists, accountNum);
            }
            RequestContext rc = DatabaseLookupUtils.findRequestContextByAccountId(account.getAccountId());
            if (rc == null) {
                return ErrorResponsePackets.newErrorPacket(++this.sequenceId, ErrorCode.ServerError_AccountNotExists, accountNum);
            }
            RequestContext.set((RequestContext)rc);
            CheckAuth checkAuth = CheckAuthDecider.decide(account, username, auth);
            Long userId = checkAuth.checkAuth();
            if (userId == null) {
                return ErrorResponsePackets.newErrorPacket(++this.sequenceId, ErrorCode.AuthenticationFailIncorrectUsernamePassword, new Object[0]);
            }
            if (rc.getUserId() == null) {
                rc.setUserId(String.valueOf(userId));
            }
            BindingRequestContextToThread.bindRequestContextWithTraceId(rc);
            Map userMap = SuperQueryService.create().userInfoMap(account, username, "zh_CN");
            SessionInfo sessionInfo = this.buildSessionInfo(account, userMap);
            String sessionId = SessionManager.newSession((HttpServletRequest)this.request, (HttpServletResponse)this.response, (Map)sessionInfo.toMap(), (boolean)true);
            this.addCsrf(sessionId);
            SessionContext sessionContext = new SessionContext(database, schema, account.getTenantId(), account.getAccountId(), userId);
            String connectionId = DriverServerAPI.get().openSession(sessionContext, host);
            return LoginResponsePacket.builder().sequenceId(++this.sequenceId).statusFlags(2).connectionId(connectionId).accountId(account.getAccountId()).build();
        }
        catch (Exception e) {
            return ErrorResponsePackets.newErrorPacket(++this.sequenceId, e);
        }
    }

    private void addCsrf(String sessionId) {
        String csrfTokenValue = SessionManager.getCSRFTokenValue((String)sessionId);
        if (csrfTokenValue != null) {
            this.response.addHeader("kd-csrf-token", csrfTokenValue);
        }
    }

    private SessionInfo buildSessionInfo(Account account, Map<String, String> userMap) {
        SessionInfo sessionInfo = new SessionInfo();
        sessionInfo.setTenantId(account.getTenantId());
        sessionInfo.setAccountId(account.getAccountId());
        sessionInfo.setOrgId(userMap.get("forgid"));
        sessionInfo.setUserId(userMap.get("fid"));
        sessionInfo.setUserName(userMap.get("ftruename"));
        String remoteHost = NetAddressUtils.getRemoteHost((HttpServletRequest)this.request);
        sessionInfo.setLoginIP(remoteHost);
        sessionInfo.setUid(userMap.get("fuid"));
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sessionInfo.setLoginTime(df.format(new Date()));
        return sessionInfo;
    }
}

