/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.server.http.packet.handler;

import kd.bos.flydb.server.http.codec.decode.ReadableByteBuf;
import kd.bos.flydb.server.http.packet.ServerPacket;
import kd.bos.flydb.server.http.packet.common.QuerySqlType;
import kd.bos.flydb.server.http.packet.handler.ServerHandler;
import kd.bos.flydb.server.http.result.ExecuteResult;
import kd.bos.flydb.server.http.result.QueryResult;
import kd.bos.flydb.server.http.util.ErrorResponsePackets;

public class QueryPacketServerHandler
implements ServerHandler {
    private final ReadableByteBuf readableByteBuf;
    private int sequenceId;

    public QueryPacketServerHandler(ReadableByteBuf readableByteBuf, int sequenceId) {
        this.readableByteBuf = readableByteBuf;
        this.sequenceId = sequenceId;
    }

    @Override
    public ServerPacket handle() {
        int fetchSize = this.readableByteBuf.readInt();
        int queryTimeout = this.readableByteBuf.readInt();
        String connectionId = this.readableByteBuf.readStringNullEnd();
        String sql = this.readableByteBuf.readStringNullEnd();
        QuerySqlType querySqlType = QuerySqlType.findQuerySqlType(sql);
        switch (querySqlType) {
            case querySQL: 
            case showTablesSQL: 
            case showOtherSQL: {
                try {
                    QueryResult queryResult = new QueryResult(sql, fetchSize, queryTimeout, this.sequenceId, connectionId);
                    return queryResult.responsePacket();
                }
                catch (Throwable throwable) {
                    return ErrorResponsePackets.newErrorPacket(++this.sequenceId, throwable);
                }
            }
            case settingsSQL: 
            case useSQL: {
                try {
                    ExecuteResult executeResult = new ExecuteResult(sql, 1, queryTimeout, this.sequenceId, connectionId);
                    return executeResult.responsePacket();
                }
                catch (Throwable throwable) {
                    return ErrorResponsePackets.newErrorPacket(++this.sequenceId, throwable);
                }
            }
        }
        throw new UnsupportedOperationException("unsupported query sql=" + sql);
    }
}

