/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.server.http.packet.server;

import java.io.IOException;
import kd.bos.flydb.server.http.codec.encode.Writer;
import kd.bos.flydb.server.http.packet.common.DataType;
import kd.bos.flydb.server.http.packet.common.ServerCharset;
import kd.bos.flydb.server.http.packet.server.AbstractServerPacket;

public class ColumnDefinitionPacket
extends AbstractServerPacket {
    String catalog;
    String schema;
    String table;
    String name;
    String columnAlias;
    byte serverCharsetId;
    long columnLength;
    DataType dataType;

    private ColumnDefinitionPacket(Builder builder) {
        super(builder.sequenceId);
        this.catalog = builder.catalog;
        this.schema = builder.schema;
        this.table = builder.table;
        this.name = builder.name;
        this.columnAlias = builder.columnAlias;
        this.serverCharsetId = builder.serverCharsetId;
        this.columnLength = builder.columnLength;
        this.dataType = builder.dataType;
    }

    @Override
    public int encode(Writer writer) throws IOException {
        writer.writeInt(this.getSequenceId());
        writer.writeString(this.catalog);
        writer.writeNull();
        writer.writeString(this.schema);
        writer.writeNull();
        writer.writeString(this.table);
        writer.writeNull();
        writer.writeString(this.name);
        writer.writeNull();
        writer.writeString(this.columnAlias);
        writer.writeNull();
        writer.writeByte(this.serverCharsetId);
        writer.writeLong(this.columnLength);
        writer.writeInt(this.dataType.get());
        return 1;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        int sequenceId;
        String catalog = "";
        String schema = "";
        String table = "";
        String name = "";
        private String columnAlias = "";
        byte serverCharsetId = ServerCharset.UTF8_GENERAL_CI.getCharsetId();
        long columnLength = -1L;
        DataType dataType;

        private Builder() {
        }

        public Builder sequenceId(int sequenceId) {
            this.sequenceId = sequenceId;
            return this;
        }

        public Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public Builder table(String table) {
            this.table = table;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder columnAlias(String columnAlias) {
            this.columnAlias = columnAlias;
            return this;
        }

        public Builder serverCharset(byte serverCharsetId) {
            this.serverCharsetId = serverCharsetId;
            return this;
        }

        public Builder columnLength(long columnLength) {
            this.columnLength = columnLength;
            return this;
        }

        public Builder dataType(DataType dataType) {
            this.dataType = dataType;
            return this;
        }

        public ColumnDefinitionPacket build() {
            return new ColumnDefinitionPacket(this);
        }
    }
}

