/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.server.http.packet.server;

import java.io.IOException;
import kd.bos.flydb.server.http.codec.encode.Writer;
import kd.bos.flydb.server.http.packet.ServerPacket;
import kd.bos.flydb.server.http.packet.common.ServerCharset;

public class HandShakeAckPacket
implements ServerPacket {
    private String serverVersion;
    private int serverStatus;
    private byte[] salt;
    private ServerCharset charset;
    private int sequenceId;

    private HandShakeAckPacket(Builder builder) {
        this.serverVersion = builder.serverVersion;
        this.serverStatus = builder.serverStatus;
        this.salt = builder.salt;
        this.charset = builder.charset;
        this.sequenceId = builder.sequenceId;
    }

    public CharSequence getServerVersion() {
        return this.serverVersion;
    }

    public int getServerStatus() {
        return this.serverStatus;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public ServerCharset getCharset() {
        return this.charset;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public int encode(Writer writer) throws IOException {
        writer.writeAscii(this.serverVersion);
        writer.writeByte(0);
        writer.writeInt((short)this.serverStatus);
        writer.writeInt((short)this.salt.length);
        writer.writeBytes(this.salt);
        writer.writeByte(this.charset.getCharsetId());
        writer.writeByte(this.sequenceId);
        return 1;
    }

    @Override
    public int getSequenceId() {
        return this.sequenceId;
    }

    public static class Builder {
        private String serverVersion;
        private int serverStatus;
        private byte[] salt;
        private ServerCharset charset;
        private int sequenceId;

        private Builder() {
        }

        public Builder serverVersion(String serverVersion) {
            this.serverVersion = serverVersion;
            return this;
        }

        public Builder serverStatus(int serverStatus) {
            this.serverStatus = serverStatus;
            return this;
        }

        public Builder authData(byte[] salt) {
            this.salt = salt;
            return this;
        }

        public Builder charset(ServerCharset charset) {
            this.charset = charset;
            return this;
        }

        public Builder sequenceId(int sequenceId) {
            this.sequenceId = sequenceId;
            return this;
        }

        public HandShakeAckPacket build() {
            return new HandShakeAckPacket(this);
        }
    }
}

