/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.server.http.packet.server;

import java.io.IOException;
import kd.bos.flydb.server.http.codec.encode.Writer;
import kd.bos.flydb.server.http.packet.server.AbstractServerPacket;

public final class LoginResponsePacket
extends AbstractServerPacket {
    private long affectedRows;
    private int serverStatus;
    private int warnings;
    private String connectionId;
    private String accountId;

    private LoginResponsePacket(Builder builder) {
        super(builder.sequenceId);
        this.affectedRows = builder.affectedRows;
        this.serverStatus = builder.serverStatus;
        this.warnings = builder.warnings;
        this.connectionId = builder.connectionId;
        this.accountId = builder.accountId;
    }

    @Override
    public int encode(Writer writer) throws IOException {
        writer.writeByte(1);
        writer.writeByte(this.getSequenceId());
        writer.writeLong(this.affectedRows);
        writer.writeInt(this.serverStatus);
        writer.writeInt(this.warnings);
        if (this.connectionId != null) {
            writer.writeString(this.connectionId);
            writer.writeNull();
        }
        if (this.accountId != null) {
            writer.writeString(this.accountId);
            writer.writeNull();
        }
        return 1;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int sequenceId;
        private long affectedRows;
        private int serverStatus;
        private int warnings;
        private String connectionId;
        private String accountId;

        public Builder sequenceId(int sequenceId) {
            this.sequenceId = sequenceId;
            return this;
        }

        public Builder affectedRows(long affectedRows) {
            this.affectedRows = affectedRows;
            return this;
        }

        public Builder statusFlags(int statusFlags) {
            this.serverStatus = statusFlags;
            return this;
        }

        public Builder warnings(int warnings) {
            this.warnings = warnings;
            return this;
        }

        public Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public LoginResponsePacket build() {
            return new LoginResponsePacket(this);
        }
    }
}

