/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.server.http.result;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.flydb.common.ServerConfig;
import kd.bos.flydb.common.ServerOption;
import kd.bos.flydb.common.config.Option;
import kd.bos.flydb.server.ResultInfo;
import kd.bos.flydb.server.http.packet.ServerPacket;
import kd.bos.flydb.server.http.packet.common.DataType;
import kd.bos.flydb.server.http.packet.common.ServerCharset;
import kd.bos.flydb.server.http.packet.server.ColumnCountPacket;
import kd.bos.flydb.server.http.packet.server.ColumnDefinitionPacket;
import kd.bos.flydb.server.http.packet.server.EofResponsePacket;
import kd.bos.flydb.server.http.packet.server.MultiServerPacket;
import kd.bos.flydb.server.http.packet.server.ResultSetRowPacket;

public abstract class AbstractResult {
    protected final int fetchSize;
    protected final int sequenceId;
    protected final String connectionId;
    protected String statementId;
    protected int[] fieldType;
    protected List<String[]> data;
    protected int length = 0;
    protected ResultInfo resultInfo;
    protected List<Row> rows;

    public AbstractResult(int fetchSize, int sequenceId, String connectionId) {
        this.fetchSize = fetchSize == 0 ? ServerConfig.getSysConfiguration().getInt((Option)ServerOption.FetchSize) : fetchSize;
        this.sequenceId = sequenceId;
        this.connectionId = connectionId;
    }

    protected abstract void init();

    protected void dealColumnCountPacket(MultiServerPacket multiServerPacket, AtomicInteger sequence) {
        int columnCount = this.resultInfo.getRowMeta().getFieldCount();
        ColumnCountPacket columnCountPacket = new ColumnCountPacket(columnCount, sequence.incrementAndGet());
        multiServerPacket.addServerPacket(columnCountPacket);
    }

    protected void dealColumnDefinitionPacket(MultiServerPacket multiServerPacket, AtomicInteger sequence) {
        for (int i = 0; i < this.resultInfo.getRowMeta().getFieldCount(); ++i) {
            Field field = this.resultInfo.getRowMeta().getField(i);
            ColumnDefinitionPacket.Builder builder = ColumnDefinitionPacket.builder().sequenceId(sequence.incrementAndGet());
            builder.name(field.getName());
            builder.columnAlias(field.getAlias());
            builder.dataType(DataType.convertToDataType(field.getDataType()));
            builder.serverCharset(ServerCharset.UTF8_GENERAL_CI.getCharsetId());
            multiServerPacket.addServerPacket(builder.build());
        }
    }

    protected void dealResultSetRow() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        this.data = new ArrayList<String[]>(this.fetchSize);
        int fieldCount = this.resultInfo.getRowMeta().getFieldCount();
        this.fieldType = new int[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            this.fieldType[i] = DataType.convertToDataType(this.resultInfo.getRowMeta().getDataType(i)).get();
        }
        for (Row row : this.rows) {
            String[] rowObjects = new String[fieldCount];
            for (int i = 0; i < fieldCount; ++i) {
                Object obj = row.get(i);
                if (obj instanceof Date) {
                    obj = sdf.format(((Date)obj).getTime());
                }
                rowObjects[i] = obj == null ? null : String.valueOf(obj);
            }
            this.data.add(rowObjects);
            if (this.fetchSize == 0 || ++this.length != this.fetchSize) continue;
            break;
        }
    }

    public ServerPacket responsePacket() {
        MultiServerPacket multiServerPacket = new MultiServerPacket(new ServerPacket[0]);
        AtomicInteger sequence = new AtomicInteger(this.sequenceId);
        this.dealColumnCountPacket(multiServerPacket, sequence);
        this.dealColumnDefinitionPacket(multiServerPacket, sequence);
        this.dealResultSetRow();
        if (this.fetchSize == 0 || this.fetchSize > this.length) {
            multiServerPacket.addServerPacket(new EofResponsePacket(sequence.incrementAndGet(), 2, this.statementId));
        } else {
            String resultId = this.resultInfo.getResultId();
            multiServerPacket.addServerPacket(new EofResponsePacket(sequence.incrementAndGet(), 8, this.statementId, resultId));
        }
        if (this.data != null && !this.data.isEmpty()) {
            for (String[] row : this.data) {
                multiServerPacket.addServerPacket(new ResultSetRowPacket(sequence.incrementAndGet(), row, this.fieldType));
            }
        }
        multiServerPacket.addServerPacket(new EofResponsePacket(sequence.incrementAndGet(), 2));
        return multiServerPacket;
    }
}

