/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.server.http.util;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kd.bos.context.RequestContext;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.tenant.listener.TenantListener;
import kd.bos.tenant.listener.TenantListenerInfo;
import kd.bos.tenant.listener.TenantListenerManager;

public final class DatabaseLookupUtils {
    private static final Log LOG = LogFactory.getLog(DatabaseLookupUtils.class);
    private static List<RequestContext> allRequestContext = new CopyOnWriteArrayList<RequestContext>();
    private static List<Account> allAccount = new CopyOnWriteArrayList<Account>();

    private DatabaseLookupUtils() {
    }

    public static Account findAccountId(String accountNum) {
        for (Account account : allAccount) {
            if (!account.getAccountNumber().trim().equals(accountNum)) continue;
            return account;
        }
        return null;
    }

    public static RequestContext findRequestContextByAccountId(String accountId) {
        for (RequestContext requestContext : allRequestContext) {
            if (!requestContext.getAccountId().equals(accountId)) continue;
            return requestContext;
        }
        return null;
    }

    static {
        try {
            List accounts = AccountUtils.getAllAccountsOfCurrentEnv();
            for (Account account : accounts) {
                RequestContext requestContext = RequestContext.create((boolean)false);
                requestContext.setAccountId(account.getAccountId());
                requestContext.setTenantId(account.getTenantId());
                allRequestContext.add(requestContext);
                allAccount.add(account);
            }
            TenantListenerManager.addTenantListener((TenantListener)new TenantListener(){

                public void onTenantAccountsRemoved(TenantListenerInfo tenantListenerInfo) {
                    Iterator it;
                    for (Account account : tenantListenerInfo.getAccountList()) {
                        it = allRequestContext.iterator();
                        while (it.hasNext()) {
                            RequestContext requestContext = (RequestContext)it.next();
                            if (!requestContext.getAccountId().equals(account.getAccountId()) || !requestContext.getTenantId().equals(tenantListenerInfo.getTenantnumber())) continue;
                            it.remove();
                        }
                    }
                    for (Account account : tenantListenerInfo.getAccountList()) {
                        it = allAccount.iterator();
                        while (it.hasNext()) {
                            Account a = (Account)it.next();
                            if (!a.getAccountId().equals(account.getAccountId()) || !a.getTenantId().equals(tenantListenerInfo.getTenantnumber())) continue;
                            it.remove();
                        }
                    }
                }

                public void onTenantAccountsAdded(TenantListenerInfo tenantListenerInfo) {
                    for (Account account : tenantListenerInfo.getAccountList()) {
                        RequestContext rc = RequestContext.create((boolean)false);
                        rc.setTenantId(tenantListenerInfo.getTenantnumber());
                        rc.setAccountId(account.getAccountId());
                        allRequestContext.add(rc);
                        allAccount.add(account);
                    }
                }
            });
        }
        catch (Exception e) {
            LOG.error("DatabaseLookupUtils lookup accounts Exception :" + e.getMessage(), (Throwable)e);
        }
    }
}

