/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.server.http.util;

import kd.bos.exception.KDException;
import kd.bos.flydb.common.exception.CoreException;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.ExceptionUtil;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.server.http.packet.server.ErrorResponsePacket;

public final class ErrorResponsePackets {
    private ErrorResponsePackets() {
    }

    public static ErrorResponsePacket newErrorPacket(int sequenceId, Throwable exception) {
        KDException kdException;
        exception = ExceptionUtil.tryUnwrapCoreException((Throwable)exception);
        int code = ErrorCode.ServerError_UnexpectedException.vendorCode;
        String message = exception.getMessage();
        if (exception instanceof CoreException) {
            code = ((CoreException)exception).getVendorCode();
        } else if (exception instanceof KDException && "DubboServiceLookup".equalsIgnoreCase((kdException = (KDException)exception).getErrorCode().getCode())) {
            code = ErrorCode.ClientError_ServerUnavailable.vendorCode;
            message = ErrorCode.ClientError_ServerUnavailable.reason;
        }
        return new ErrorResponsePacket(sequenceId, code, message);
    }

    public static ErrorResponsePacket newErrorPacket(int sequenceId, ErrorCode errorCode, Object ... arg) {
        return ErrorResponsePackets.newErrorPacket(sequenceId, (Throwable)Exceptions.of((ErrorCode)errorCode, (Object[])arg));
    }
}

