/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.server.http.util;

import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.server.http.codec.encode.impl.PacketWriter;
import kd.bos.flydb.server.http.packet.server.ErrorResponsePacket;
import kd.bos.flydb.server.http.util.ErrorResponsePackets;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public final class ResponseUtil {
    private static final Log LOG = LogFactory.getLog((String)"FlyDBWeb");

    public static void serverError(HttpServletResponse servletResponse, String logMsg, Throwable logThrow, int sequenceId, ErrorCode errorCode, Object ... arg) {
        if (logThrow == null) {
            com.esotericsoftware.minlog.Log.error((String)logMsg);
        } else {
            com.esotericsoftware.minlog.Log.error((String)logMsg, (Throwable)logThrow);
        }
        try (ServletOutputStream outputStream = servletResponse.getOutputStream();){
            ErrorResponsePacket errorResponsePacket = ErrorResponsePackets.newErrorPacket(sequenceId, errorCode, arg);
            PacketWriter writer = new PacketWriter((OutputStream)outputStream, errorResponsePacket.getSequenceId());
            errorResponsePacket.encode(writer);
            writer.flush();
        }
        catch (Exception e) {
            LOG.error("FlyDBWeb cause an error when send unexpected server error to client, msg: " + e.getMessage(), (Throwable)e);
            servletResponse.setStatus(400);
        }
    }
}

