/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.server.serialize;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import kd.bos.flydb.server.serialize.Serialize;

public class DefaultSerialize
implements Serialize {
    private final int bufferSize;

    public DefaultSerialize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    @Override
    public byte[] write(Object object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(this.bufferSize);
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(object);
        byte[] bs = baos.toByteArray();
        baos.close();
        oos.close();
        return bs;
    }

    @Override
    public Object read(byte[] bytes) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = new ObjectInputStream(bais);
        Object obj = null;
        try {
            obj = ois.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        bais.close();
        ois.close();
        return obj;
    }
}

