/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.server.session2;

import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextThreadBinder;
import kd.bos.flydb.common.ServerConfig;
import kd.bos.flydb.common.SessionContextOption;
import kd.bos.flydb.common.config.Configuration;
import kd.bos.flydb.common.config.Option;
import kd.bos.flydb.common.config.RedisConfiguration;
import kd.bos.trace.util.TraceIdUtil;

public class ServerRuntimeContext
implements AutoCloseable {
    private static final ThreadLocal<ServerRuntimeContext> threadLocal = new ThreadLocal();
    private final ServerRuntimeContext parent = threadLocal.get();
    private final String sessionId;
    private final RedisConfiguration configuration;
    private final RequestContext snapshot;

    public ServerRuntimeContext(String sessionId) {
        this.sessionId = sessionId;
        this.configuration = new RedisConfiguration(sessionId);
        this.snapshot = RequestContext.get();
        this.setupRequestContext();
        threadLocal.set(this);
    }

    public static ServerRuntimeContext get() {
        return threadLocal.get();
    }

    public Configuration getConfiguration() {
        return ServerConfig.getSessionABCConfiguration((String)this.sessionId);
    }

    public final void setupRequestContext() {
        String tenantId = this.configuration.getString((Option)SessionContextOption.TenantId);
        String accountId = this.configuration.getString((Option)SessionContextOption.AccountId);
        long userId = this.configuration.getLong((Option)SessionContextOption.UserId);
        String username = this.configuration.getString((Option)SessionContextOption.Username);
        RequestContext requestContext = RequestContext.create();
        requestContext.setTenantId(tenantId);
        requestContext.setAccountId(accountId);
        requestContext.setUserId(String.valueOf(userId));
        requestContext.setUserName(username);
        if (this.snapshot != null && this.snapshot.getTraceId() != null) {
            requestContext.setTraceId(this.snapshot.getTraceId());
        }
        if (requestContext.getTraceId() == null) {
            requestContext.setTraceId(TraceIdUtil.createTraceIdString());
        }
        this.resetRequestContext(requestContext);
    }

    @Override
    public void close() {
        ServerRuntimeContext config = threadLocal.get();
        ServerRuntimeContext parent = config.parent;
        if (parent != null) {
            threadLocal.set(parent);
            this.resetRequestContext(parent.snapshot);
        } else {
            this.resetRequestContext(this.snapshot);
        }
    }

    private void resetRequestContext(RequestContext requestContext) {
        if (requestContext != null) {
            RequestContext.set((RequestContext)requestContext);
            RequestContextThreadBinder.bind((RequestContext)requestContext);
        } else {
            RequestContext.set(null);
        }
    }
}

