/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.server.session2;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.context.OperationContext;
import kd.bos.context.OperationContextCreator;
import kd.bos.elect.ElectFactory;
import kd.bos.elect.Elector;
import kd.bos.elect.ElectorListener;
import kd.bos.flydb.common.FlyDBConstants;
import kd.bos.flydb.server.core.CoreService;
import kd.bos.flydb.server.session2.SessionManager;
import kd.bos.thread.ThreadLifeCycleManager;

public class SessionCleanService {
    private static final AtomicBoolean start = new AtomicBoolean(false);
    private static SessionManager sessionManager;

    public static void setSessionManager(SessionManager sessionManager) {
        SessionCleanService.sessionManager = sessionManager;
    }

    static SessionManager getDefault() {
        return CoreService.getSessionManager();
    }

    static synchronized void clean() {
        if (sessionManager == null) {
            sessionManager = SessionCleanService.getDefault();
        }
        sessionManager.cleanTimeoutSession();
    }

    public static void start() {
        if (start.compareAndSet(false, true)) {
            Elector elector = ElectFactory.getElector((String)("flydb.session_clean_elector_" + FlyDBConstants.getKeyWithRegion()));
            elector.registerListener((ElectorListener)new CleanServiceElectorListener());
            elector.start();
        }
    }

    public static class Runnable1
    implements Runnable {
        private Runnable delegate;

        public Runnable1(Runnable delegate) {
            this.delegate = delegate;
            this.delegate = ThreadLifeCycleManager.wrapRunnable((Runnable)delegate);
        }

        @Override
        public void run() {
            try {
                OperationContext.remove();
                OperationContextCreator.getOrCreateForBos();
            }
            catch (Exception exception) {
            }
            finally {
                this.delegate.run();
            }
        }
    }

    public static class CleanServiceElectorListener
    implements ElectorListener {
        private ScheduledExecutorService scheduledExecutorService;

        public void notifyMaster() {
            if (this.scheduledExecutorService == null) {
                this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(r -> {
                    Runnable1 runnable = new Runnable1(r);
                    Thread mainThread = new Thread(runnable);
                    mainThread.setDaemon(true);
                    mainThread.setName("FlyDB-Session-Clean");
                    return mainThread;
                });
                this.scheduledExecutorService.scheduleWithFixedDelay(SessionCleanService::clean, 0L, 30L, TimeUnit.MINUTES);
            }
        }

        public void notifyLostMaster() {
            if (this.scheduledExecutorService != null) {
                this.scheduledExecutorService.shutdown();
                this.scheduledExecutorService = null;
            }
        }
    }
}

