/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.server.session2;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Properties;
import kd.bos.algox.RunningTimeoutException;
import kd.bos.flydb.common.AlgoXOption;
import kd.bos.flydb.common.ServerConfig;
import kd.bos.flydb.common.ServerOption;
import kd.bos.flydb.common.SessionContextOption;
import kd.bos.flydb.common.config.ABCConfiguration;
import kd.bos.flydb.common.config.Configuration;
import kd.bos.flydb.common.config.Option;
import kd.bos.flydb.common.config.RedisConfiguration;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.common.util.RedisCounter;
import kd.bos.flydb.common.util.RedisSet;
import kd.bos.flydb.core.Core;
import kd.bos.flydb.core.interpreter.Executor;
import kd.bos.flydb.server.ResultInfo;
import kd.bos.flydb.server.core.Ids;
import kd.bos.flydb.server.facade.WorkerAPI;
import kd.bos.flydb.server.session2.ServerRuntimeContext;
import kd.bos.flydb.server.session2.Session;
import kd.bos.flydb.server.session2.SessionEventHandleService;
import kd.bos.flydb.server.session2.SessionManager;
import kd.bos.flydb.server.session2.SessionRefreshExpireTimeEvent;
import kd.bos.flydb.server.session2.SessionStateChangeEvent;
import kd.bos.flydb.server.session2.storage.EntityStorage;
import kd.bos.flydb.server.session2.storage.ResultSetEntity;
import kd.bos.flydb.server.session2.storage.SessionEntity;
import kd.bos.flydb.server.session2.storage.SessionStateEntity;
import kd.bos.flydb.server.session2.storage.SessionTimeoutEntity;
import kd.bos.flydb.server.session2.storage.StatementEntity;

public class SessionImpl
implements Session {
    private WorkerAPI workerAPI;
    private EntityStorage entityStorage;
    private SessionEventHandleService eventHandleService;
    private SessionManager sessionManager;
    private final String id;

    public SessionImpl(String id) {
        this.id = id;
    }

    public void setWorkerAPI(WorkerAPI workerAPI) {
        this.workerAPI = workerAPI;
    }

    public void setEntityStorage(EntityStorage entityStorage) {
        this.entityStorage = entityStorage;
    }

    public void setEventHandleService(SessionEventHandleService eventHandleService) {
        this.eventHandleService = eventHandleService;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    @Override
    public String getId() {
        return this.id;
    }

    private void beforePrepare(String sql) {
        SessionStateChangeEvent event = new SessionStateChangeEvent(this, System.currentTimeMillis(), "Prepare", "executing", sql);
        this.eventHandleService.submit(event);
    }

    @Override
    public String prepare(String sql) {
        this.beforePrepare(sql);
        String stmtId = Ids.createId();
        this.getStmtIdSet().add(stmtId);
        StatementEntity statementEntity = new StatementEntity(stmtId, this.id);
        this.entityStorage.save(statementEntity);
        this.afterPrepare();
        return stmtId;
    }

    private void afterPrepare() {
        SessionStateChangeEvent sleepEvent = new SessionStateChangeEvent(this, System.currentTimeMillis(), "Sleep", "", "");
        this.eventHandleService.submit(sleepEvent);
        this.eventHandleService.submit(new SessionRefreshExpireTimeEvent(this.id, this.sessionManager));
    }

    private void beforeExecuteQuery(String sql) {
        SessionStateChangeEvent event = new SessionStateChangeEvent(this, System.currentTimeMillis(), "Query", "executing", sql);
        this.eventHandleService.submit(event);
    }

    @Override
    public ResultInfo executeQuery(String stmtId, String sql, Object[] param) {
        this.checkClosed();
        this.refreshSessionTimeout();
        this.beforeExecuteQuery(sql);
        try {
            Executor.Result result;
            Throwable throwable;
            ServerRuntimeContext ignored;
            block26: {
                ResultInfo resultInfo;
                block27: {
                    block28: {
                        String resultId;
                        block23: {
                            ResultInfo resultInfo2;
                            block24: {
                                block25: {
                                    ignored = new ServerRuntimeContext(this.id);
                                    throwable = null;
                                    ABCConfiguration configuration = ServerConfig.getStatementABCConfiguration((String)this.id, (String)stmtId);
                                    result = Core.execute((String)this.id, (String)configuration.getString((Option)SessionContextOption.Schema), (Long)configuration.getLong((Option)SessionContextOption.UserId), (Properties)this.buildExecuteProperties((Configuration)configuration), (String)sql, (Object[])param);
                                    resultId = Ids.createId();
                                    this.getResultIdSet(stmtId).add(resultId);
                                    if (!(result instanceof Executor.QueryResult)) break block23;
                                    Executor.QueryResult queryResult = (Executor.QueryResult)result;
                                    ResultSetEntity resultSetEntity = new ResultSetEntity(resultId, stmtId, queryResult.cursorId, this.id);
                                    this.entityStorage.save(resultSetEntity);
                                    RedisCounter cursorReferenceCounter = this.getCursorReferenceCounter(queryResult.cursorId);
                                    cursorReferenceCounter.incrementAndGet();
                                    resultInfo2 = this.workerAPI.getResultInfo(resultId);
                                    if (ignored == null) break block24;
                                    if (throwable == null) break block25;
                                    try {
                                        ignored.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    break block24;
                                }
                                ignored.close();
                            }
                            return resultInfo2;
                        }
                        if (!(result instanceof Executor.ExecuteResult)) break block26;
                        resultInfo = new ResultInfo(resultId, result.getMeta(), 0L, 0);
                        if (ignored == null) break block27;
                        if (throwable == null) break block28;
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        break block27;
                    }
                    ignored.close();
                }
                return resultInfo;
            }
            try {
                try {
                    try {
                        throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedQuery, (Object[])new Object[]{result});
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    if (ignored != null) {
                        if (throwable != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                        } else {
                            ignored.close();
                        }
                    }
                    throw throwable5;
                }
            }
            catch (Exception e) {
                if (e instanceof RunningTimeoutException) {
                    throw Exceptions.of((ErrorCode)ErrorCode.QueryTimeout, (Object[])new Object[0]);
                }
                throw e;
            }
        }
        finally {
            this.afterExecuteQuery();
        }
    }

    private void afterExecuteQuery() {
        SessionStateChangeEvent sleepEvent = new SessionStateChangeEvent(this, System.currentTimeMillis(), "Sleep", "", "");
        this.eventHandleService.submit(sleepEvent);
        this.eventHandleService.submit(new SessionRefreshExpireTimeEvent(this.id, this.sessionManager));
    }

    private RedisCounter getCursorReferenceCounter(String cursorId) {
        return new RedisCounter(this.getClass().getName() + "#cursorReferenceCounter", cursorId);
    }

    private RedisSet getResultIdSet(String stmtId) {
        return new RedisSet(this.getClass().getName() + "#resultIdSet", stmtId);
    }

    private RedisSet getStmtIdSet() {
        return new RedisSet(this.getClass().getName() + "#stmtIdSet", this.id);
    }

    private Properties buildExecuteProperties(Configuration configuration) {
        Properties properties = new Properties();
        ArrayList ignoredOptions = Lists.newArrayList((Object[])ServerConfig.getSessionIgnoreOptions());
        for (ServerOption serverOption : ServerOption.values()) {
            if (ignoredOptions.contains(serverOption)) continue;
            properties.put(serverOption.key(), configuration.getAsString((Option)serverOption));
        }
        for (ServerOption serverOption : SessionContextOption.values()) {
            properties.put(serverOption.key(), configuration.getAsString((Option)serverOption));
        }
        for (ServerOption serverOption : AlgoXOption.values()) {
            properties.put(serverOption.key(), configuration.getAsString((Option)serverOption));
        }
        return properties;
    }

    private void beforeCopy() {
        SessionStateChangeEvent sleepEvent = new SessionStateChangeEvent(this, System.currentTimeMillis(), "Copy", "executing", "");
        this.eventHandleService.submit(sleepEvent);
    }

    private void refreshSessionTimeout() {
        SessionTimeoutEntity timeoutEntity = this.entityStorage.get(this.id, SessionTimeoutEntity.class);
        if (System.currentTimeMillis() > timeoutEntity.getLastUpdateTimestamp()) {
            timeoutEntity.setLastUpdateTimestamp(System.currentTimeMillis());
            this.entityStorage.save(timeoutEntity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultInfo copy(String rsId) {
        this.checkClosed();
        this.refreshSessionTimeout();
        this.beforeCopy();
        try {
            ResultSetEntity resultSetEntity = this.entityStorage.get(rsId, ResultSetEntity.class);
            if (resultSetEntity == null) {
                throw new RuntimeException("ResultSet not exists.");
            }
            String newRsId = Ids.createId();
            this.getResultIdSet(resultSetEntity.getStmtId()).add(newRsId);
            ResultSetEntity newResultSetEntity = new ResultSetEntity(newRsId, resultSetEntity.getStmtId(), resultSetEntity.getCursorId(), this.id);
            this.entityStorage.save(newResultSetEntity);
            RedisCounter cursorReferenceCounter = this.getCursorReferenceCounter(resultSetEntity.getCursorId());
            cursorReferenceCounter.incrementAndGet();
            ResultInfo resultInfo = this.workerAPI.getResultInfo(newRsId);
            return resultInfo;
        }
        finally {
            this.afterCopy();
        }
    }

    private void afterCopy() {
        SessionStateChangeEvent sleepEvent = new SessionStateChangeEvent(this, System.currentTimeMillis(), "Sleep", "", "");
        this.eventHandleService.submit(sleepEvent);
        this.eventHandleService.submit(new SessionRefreshExpireTimeEvent(this.id, this.sessionManager));
    }

    @Override
    public void closeResultSet(String rsId) {
        ResultSetEntity resultSetEntity = this.entityStorage.get(rsId, ResultSetEntity.class);
        if (resultSetEntity == null) {
            return;
        }
        RedisCounter cursorReferenceCounter = this.getCursorReferenceCounter(resultSetEntity.getCursorId());
        if (cursorReferenceCounter.decrementAndGet() == 0L) {
            this.workerAPI.closeCursor(resultSetEntity.getCursorId());
            cursorReferenceCounter.release();
        }
        this.entityStorage.delete(resultSetEntity);
        this.getResultIdSet(resultSetEntity.getStmtId()).remove(rsId);
        this.eventHandleService.submit(new SessionRefreshExpireTimeEvent(this.id, this.sessionManager));
    }

    @Override
    public void close() {
        for (String stmtId : this.getStmtIdSet().list()) {
            this.closeStatement(stmtId);
        }
        this.getStmtIdSet().release();
        ServerConfig.getSessionConfiguration((String)this.id).release();
    }

    @Override
    public void expire(long seconds) {
        for (String stmtId : this.getStmtIdSet().list()) {
            this.expireStatement(stmtId, seconds);
        }
        this.getStmtIdSet().expire(seconds);
        ServerConfig.getSessionConfiguration((String)this.id).expire(seconds);
    }

    @Override
    public void closeStatement(String stmtId) {
        for (String resultIds : this.getResultIdSet(stmtId).list()) {
            ResultSetEntity resultSetEntity = this.entityStorage.get(resultIds, ResultSetEntity.class);
            if (resultSetEntity == null) continue;
            RedisCounter cursorReferenceCounter = this.getCursorReferenceCounter(resultSetEntity.getCursorId());
            cursorReferenceCounter.release();
            this.workerAPI.closeCursor(resultSetEntity.getCursorId());
            this.entityStorage.delete(resultSetEntity);
        }
        this.getResultIdSet(stmtId).release();
        ServerConfig.getStatementConfiguration((String)this.id, (String)stmtId).release();
        StatementEntity statementEntity = this.entityStorage.get(stmtId, StatementEntity.class);
        this.entityStorage.delete(statementEntity);
        this.getStmtIdSet().remove(stmtId);
        this.eventHandleService.submit(new SessionRefreshExpireTimeEvent(this.id, this.sessionManager));
    }

    private void expireStatement(String stmtId, long seconds) {
        for (String resultIds : this.getResultIdSet(stmtId).list()) {
            ResultSetEntity resultSetEntity = this.entityStorage.get(resultIds, ResultSetEntity.class);
            if (resultSetEntity == null) continue;
            RedisCounter cursorReferenceCounter = this.getCursorReferenceCounter(resultSetEntity.getCursorId());
            cursorReferenceCounter.expire(seconds);
            this.entityStorage.expire(resultSetEntity, seconds);
        }
        this.getResultIdSet(stmtId).expire(seconds);
        ServerConfig.getStatementConfiguration((String)this.id, (String)stmtId).expire(seconds);
        StatementEntity statementEntity = this.entityStorage.get(stmtId, StatementEntity.class);
        this.entityStorage.expire(statementEntity, seconds);
    }

    @Override
    public void checkClosed() {
        SessionEntity sessionEntity = this.entityStorage.get(this.id, SessionEntity.class);
        if (sessionEntity == null) {
            throw Exceptions.of((ErrorCode)ErrorCode.ServerError_SessionClosed, (Object[])new Object[0]);
        }
        if (sessionEntity.isClosed()) {
            throw Exceptions.of((ErrorCode)ErrorCode.ServerError_SessionClosed, (Object[])new Object[0]);
        }
    }

    @Override
    public boolean isClosed() {
        SessionEntity sessionEntity = this.entityStorage.get(this.id, SessionEntity.class);
        if (sessionEntity == null) {
            return true;
        }
        return sessionEntity.isClosed();
    }

    @Override
    public RedisConfiguration getSessionConfiguration() {
        return ServerConfig.getSessionConfiguration((String)this.id);
    }

    @Override
    public RedisConfiguration getStatementConfiguration(String stmtId) {
        return ServerConfig.getStatementConfiguration((String)this.id, (String)stmtId);
    }

    @Override
    public Configuration getConfiguration() {
        return ServerConfig.getSessionABCConfiguration((String)this.id);
    }

    @Override
    public SessionStateEntity getState() {
        return this.entityStorage.get(this.id, SessionStateEntity.class);
    }

    @Override
    public void setSessionState(SessionStateEntity stateEntity) {
        if (stateEntity != null && stateEntity.getId() != null) {
            this.entityStorage.save(stateEntity);
        }
    }

    @Override
    public void updateSessionState(long startTime, String command, String state, String info) {
        SessionStateEntity entity = this.entityStorage.get(this.id, SessionStateEntity.class);
        if (entity != null) {
            if (entity.getStartTime() > startTime) {
                return;
            }
            entity.setStartTime(startTime);
            entity.setCommand(command);
            entity.setState(state);
            entity.setInfo(info);
            this.entityStorage.save(entity);
        }
    }

    @Override
    public void updateSessionState(long startTime, String schema) {
        SessionStateEntity entity = this.entityStorage.get(this.id, SessionStateEntity.class);
        if (entity != null) {
            if (entity.getStartTime() > startTime) {
                return;
            }
            entity.setStartTime(startTime);
            entity.setSchema(schema);
            this.entityStorage.save(entity);
        }
    }
}

