/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.server.session2;

import java.util.function.Supplier;
import kd.bos.flydb.server.facade.WorkerAPI;
import kd.bos.flydb.server.session2.LoginPermissionVerification;
import kd.bos.flydb.server.session2.SessionEventHandleService;
import kd.bos.flydb.server.session2.SessionManager;
import kd.bos.flydb.server.session2.SessionManagerImpl;
import kd.bos.flydb.server.session2.storage.EntityStorage;
import kd.bos.flydb.server.session2.storage.SessionManagerStorage;

public class SessionManagerBuilder {
    private Supplier<WorkerAPI> workerAPISupplier;
    private Supplier<EntityStorage> entityStorageSupplier;
    private Supplier<SessionManagerStorage> sessionManagerStorageSupplier;
    private Supplier<LoginPermissionVerification> loginPermissionVerificationSupplier;
    private Supplier<SessionEventHandleService> sessionEventHandleServiceSupplier;

    public SessionManagerBuilder setWorkerAPISupplier(Supplier<WorkerAPI> workerAPISupplier) {
        this.workerAPISupplier = workerAPISupplier;
        return this;
    }

    public SessionManagerBuilder setEntityStorageSupplier(Supplier<EntityStorage> entityStorageSupplier) {
        this.entityStorageSupplier = entityStorageSupplier;
        return this;
    }

    public SessionManagerBuilder setSessionManagerStorageSupplier(Supplier<SessionManagerStorage> sessionManagerStorageSupplier) {
        this.sessionManagerStorageSupplier = sessionManagerStorageSupplier;
        return this;
    }

    public SessionManagerBuilder setLoginPermissionVerificationSupplier(Supplier<LoginPermissionVerification> loginPermissionVerificationSupplier) {
        this.loginPermissionVerificationSupplier = loginPermissionVerificationSupplier;
        return this;
    }

    public SessionManagerBuilder setSessionEventHandleService(Supplier<SessionEventHandleService> sessionEventHandleServiceSupplier) {
        this.sessionEventHandleServiceSupplier = sessionEventHandleServiceSupplier;
        return this;
    }

    public SessionManager build() {
        SessionManagerImpl impl = new SessionManagerImpl();
        impl.setEntityStorage(this.entityStorageSupplier.get());
        impl.setWorkerAPI(this.workerAPISupplier.get());
        impl.setStorage(this.sessionManagerStorageSupplier.get());
        impl.setLoginPermissionVerification(this.loginPermissionVerificationSupplier.get());
        impl.setSessionEventHandleService(this.sessionEventHandleServiceSupplier.get());
        return impl;
    }
}

