/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.server.session2;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.flydb.common.ServerConfig;
import kd.bos.flydb.common.ServerOption;
import kd.bos.flydb.common.SessionContextOption;
import kd.bos.flydb.common.config.Configuration;
import kd.bos.flydb.common.config.Option;
import kd.bos.flydb.common.config.RedisConfiguration;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.manager.metadata.PrivilegeType;
import kd.bos.flydb.server.ClientType;
import kd.bos.flydb.server.SessionContext;
import kd.bos.flydb.server.core.Ids;
import kd.bos.flydb.server.facade.WorkerAPI;
import kd.bos.flydb.server.session2.CloseSessionEvent;
import kd.bos.flydb.server.session2.InitSessionEvent;
import kd.bos.flydb.server.session2.LoginPermissionVerification;
import kd.bos.flydb.server.session2.ServerRuntimeContext;
import kd.bos.flydb.server.session2.Session;
import kd.bos.flydb.server.session2.SessionEventHandleService;
import kd.bos.flydb.server.session2.SessionImpl;
import kd.bos.flydb.server.session2.SessionManager;
import kd.bos.flydb.server.session2.SessionRefreshExpireTimeEvent;
import kd.bos.flydb.server.session2.SessionStateChangeEvent;
import kd.bos.flydb.server.session2.storage.EntityStorage;
import kd.bos.flydb.server.session2.storage.SessionEntity;
import kd.bos.flydb.server.session2.storage.SessionManagerStorage;
import kd.bos.flydb.server.session2.storage.SessionStateEntity;
import kd.bos.flydb.server.session2.storage.SessionTimeoutEntity;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;

public class SessionManagerImpl
implements SessionManager {
    private WorkerAPI workerAPI;
    private EntityStorage entityStorage;
    private SessionManagerStorage storage;
    private LoginPermissionVerification loginPermissionVerification;
    private SessionEventHandleService sessionEventHandleService;

    public void setWorkerAPI(WorkerAPI workerAPI) {
        this.workerAPI = workerAPI;
    }

    public void setEntityStorage(EntityStorage entityStorage) {
        this.entityStorage = entityStorage;
    }

    public void setStorage(SessionManagerStorage storage) {
        this.storage = storage;
    }

    public void setLoginPermissionVerification(LoginPermissionVerification loginPermissionVerification) {
        this.loginPermissionVerification = loginPermissionVerification;
    }

    public void setSessionEventHandleService(SessionEventHandleService sessionEventHandleService) {
        this.sessionEventHandleService = sessionEventHandleService;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getUsername(long userId) {
        try (DataSet dataSet = ORM.create().queryDataSet(SessionManagerImpl.class.getSimpleName(), "bos_user", "name", new QFilter[]{QFilter.of((String)"id=?", (Object[])new Object[]{userId})});){
            if (!dataSet.hasNext()) return "unknown user";
            String string = dataSet.next().getString("name");
            return string;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "unknown user";
    }

    public void initSessionConfiguration(SessionContext sessionContext, String sessionId) {
        Configuration globalConfiguration = ServerConfig.getSysConfiguration();
        RedisConfiguration configuration = new RedisConfiguration(sessionId);
        configuration.setString((Option)SessionContextOption.AccountId, sessionContext.getAccountId());
        configuration.setString((Option)SessionContextOption.TenantId, sessionContext.getTenantId());
        configuration.setLong((Option)SessionContextOption.UserId, Long.valueOf(sessionContext.getUserId()));
        configuration.setString((Option)SessionContextOption.Username, SessionManagerImpl.getUsername(sessionContext.getUserId()));
        configuration.setString((Option)SessionContextOption.Database, sessionContext.getDatabase());
        configuration.setString((Option)SessionContextOption.Schema, sessionContext.getSchema());
        configuration.setString((Option)SessionContextOption.LanguageEnv, "zh_CN");
        configuration.copyOption((Option)ServerOption.AlgoXRegion, globalConfiguration);
        configuration.copyOption((Option)ServerOption.AuthPlugin, globalConfiguration);
        configuration.copyOption((Option)ServerOption.FetchSize, globalConfiguration);
        configuration.copyOption((Option)ServerOption.QueryTimeout, globalConfiguration);
        configuration.copyOption((Option)ServerOption.EnableReadonlyFirst, globalConfiguration);
        configuration.copyOption((Option)ServerOption.SessionTimeout, globalConfiguration);
        configuration.copyOption((Option)ServerOption.AlgoXOutputMaxLifeTime, globalConfiguration);
    }

    @Override
    public Session openSession(SessionContext context, String clientInfo, ClientType clientType) {
        PrivilegeType[] privileges = clientType == ClientType.JDBC_CLIENT ? PrivilegeType.of((PrivilegeType[])new PrivilegeType[]{PrivilegeType.JDBC_CONNECT}) : PrivilegeType.of((PrivilegeType[])new PrivilegeType[0]);
        boolean checkResult = this.loginPermissionVerification.check(context.getUserId(), privileges, context.getDatabase(), context.getSchema());
        if (!checkResult) {
            throw Exceptions.of((ErrorCode)ErrorCode.SchemaNotExist, (Object[])new Object[]{context.getDatabase(), context.getSchema()});
        }
        String id = Ids.createId();
        this.storage.register(id);
        SessionEntity session = new SessionEntity(id, false);
        SessionTimeoutEntity timeoutEntity = new SessionTimeoutEntity(id, System.currentTimeMillis());
        this.entityStorage.save(session);
        this.entityStorage.save(timeoutEntity);
        this.initSessionConfiguration(context, id);
        try (ServerRuntimeContext serverRuntimeContext = new ServerRuntimeContext(id);){
            SessionImpl impl = this.getSession(id);
            Configuration configuration = serverRuntimeContext.getConfiguration();
            SessionStateEntity stateEntity = new SessionStateEntity(id, configuration.getString((Option)SessionContextOption.Username), configuration.getString((Option)SessionContextOption.Database), configuration.getString((Option)SessionContextOption.Schema), clientInfo, clientType.name(), "Open", System.currentTimeMillis(), "executing", "");
            this.getEventHandleService().submit(new InitSessionEvent(impl, stateEntity));
            this.getEventHandleService().submit(new SessionRefreshExpireTimeEvent(id, this));
            SessionImpl sessionImpl = impl;
            return sessionImpl;
        }
    }

    private void beforeCloseSession(String sessionId) {
        SessionImpl session = this.getSession(sessionId);
        SessionStateChangeEvent sleepEvent = new SessionStateChangeEvent(session, System.currentTimeMillis(), "Close", "executing", "");
        this.getEventHandleService().submit(sleepEvent);
    }

    @Override
    public void closeSession(String sessionId) {
        this.beforeCloseSession(sessionId);
        SessionEntity sessionEntity = this.entityStorage.get(sessionId, SessionEntity.class);
        sessionEntity.setClosed(true);
        this.entityStorage.save(sessionEntity);
        SessionImpl session = this.getSession(sessionId);
        session.close();
        SessionStateEntity sessionStateEntity = this.entityStorage.get(sessionId, SessionStateEntity.class);
        SessionTimeoutEntity timeoutEntity = this.entityStorage.get(sessionId, SessionTimeoutEntity.class);
        this.entityStorage.delete(sessionStateEntity);
        this.entityStorage.delete(timeoutEntity);
        this.entityStorage.delete(sessionEntity);
        this.storage.unregister(sessionId);
    }

    @Override
    public void expireSession(String sessionId, long seconds) {
        SessionEntity sessionEntity = this.entityStorage.get(sessionId, SessionEntity.class);
        this.entityStorage.expire(sessionEntity, seconds);
        SessionImpl session = this.getSession(sessionId);
        session.expire(seconds);
        SessionStateEntity sessionStateEntity = this.entityStorage.get(sessionId, SessionStateEntity.class);
        SessionTimeoutEntity timeoutEntity = this.entityStorage.get(sessionId, SessionTimeoutEntity.class);
        this.entityStorage.expire(sessionStateEntity, seconds);
        this.entityStorage.expire(timeoutEntity, seconds);
        this.entityStorage.expire(sessionEntity, seconds);
    }

    @Override
    public void asyncCloseSession(String sessionId) {
        this.getEventHandleService().submit(new CloseSessionEvent(this, sessionId));
    }

    @Override
    public List<Session> listSession() {
        Set<String> sessionIds = this.storage.list();
        ArrayList<Session> sessions = new ArrayList<Session>(sessionIds.size());
        for (String sessionId : sessionIds) {
            sessions.add(this.getSession(sessionId));
        }
        return sessions;
    }

    @Override
    public SessionImpl getSession(String sessionId) {
        SessionImpl session = new SessionImpl(sessionId);
        session.setWorkerAPI(this.workerAPI);
        session.setEntityStorage(this.entityStorage);
        session.setEventHandleService(this.sessionEventHandleService);
        session.setSessionManager(this);
        return session;
    }

    @Override
    public EntityStorage getEntityStorage() {
        return this.entityStorage;
    }

    @Override
    public void cleanTimeoutSession() {
        for (Session session : this.listSession()) {
            SessionTimeoutEntity timeoutEntity = this.entityStorage.get(session.getId(), SessionTimeoutEntity.class);
            if (timeoutEntity == null) {
                this.closeSession(session.getId());
                continue;
            }
            Configuration configuration = session.getConfiguration();
            int timeout = configuration.getInt((Option)ServerOption.SessionTimeout) * 1000;
            if (timeoutEntity.getLastUpdateTimestamp() + (long)timeout >= System.currentTimeMillis()) continue;
            this.closeSession(session.getId());
        }
    }

    @Override
    public SessionEventHandleService getEventHandleService() {
        return this.sessionEventHandleService;
    }
}

