/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.server.session2;

import java.util.concurrent.TimeUnit;
import kd.bos.flydb.common.ServerConfig;
import kd.bos.flydb.common.ServerOption;
import kd.bos.flydb.common.config.Option;
import kd.bos.flydb.server.common.LogUtil;
import kd.bos.flydb.server.session2.SessionManager;

public class SessionRefreshExpireTimeEvent
implements Runnable {
    private final String sessionId;
    private final SessionManager sessionManager;

    public SessionRefreshExpireTimeEvent(String sessionId, SessionManager sessionManager) {
        this.sessionId = sessionId;
        this.sessionManager = sessionManager;
    }

    @Override
    public void run() {
        try {
            long timeoutSeconds = ServerConfig.getSysConfiguration().getInt((Option)ServerOption.SessionTimeout).intValue();
            this.sessionManager.expireSession(this.sessionId, timeoutSeconds += TimeUnit.HOURS.toSeconds(1L));
        }
        catch (Exception exception2) {
            RuntimeException exception2 = new RuntimeException("Cause an exception when refresh session expire time: " + exception2.getMessage(), exception2);
            LogUtil.logError(exception2);
        }
    }
}

