/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.server.session2.storage.redis;

import java.io.IOException;
import java.util.Objects;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.flydb.common.util.JedisClientResource;
import kd.bos.flydb.common.util.RedisKeyFormat;
import kd.bos.flydb.server.serialize.Serialize;
import kd.bos.flydb.server.serialize.SerializeManager;
import kd.bos.flydb.server.session2.storage.Entity;
import kd.bos.flydb.server.session2.storage.EntityStorage;

public class RedisEntityStorage
implements EntityStorage {
    private static final Serialize SERIALIZE = new SerializeManager("hessian", 4096);

    protected byte[] getBeanKey(Class<?> eClass, String id) {
        return RedisKeyFormat.getKey((String)eClass.getName(), (String)id);
    }

    @Override
    public void save(Entity instance) {
        Objects.requireNonNull(instance, "Entity must not be null");
        Objects.requireNonNull(instance.getId(), "Entity id must not be null");
        byte[] key = this.getBeanKey(instance.getClass(), instance.getId());
        try (JedisClientResource resource = JedisClientResource.create();){
            resource.getClient().set(key, SERIALIZE.write(instance));
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{"Create error, msg: " + e.getMessage()});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T extends Entity> T get(String id, Class<T> tClass) {
        Objects.requireNonNull(id, "id require none null value");
        byte[] key = this.getBeanKey(tClass, id);
        try (JedisClientResource resource = JedisClientResource.create();){
            if (!resource.getClient().exists(key).booleanValue()) {
                T t = null;
                return t;
            }
            Entity entity = (Entity)SERIALIZE.read(resource.getClient().get(key));
            return (T)entity;
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{"get error, msg: " + e.getMessage()});
        }
    }

    @Override
    public void delete(Entity entity) {
        if (entity == null) {
            return;
        }
        byte[] key = this.getBeanKey(entity.getClass(), entity.getId());
        try (JedisClientResource resource = JedisClientResource.create();){
            if (!resource.getClient().exists(key).booleanValue()) {
                return;
            }
            resource.getClient().del(key);
        }
    }

    @Override
    public void expire(Entity instance, long seconds) {
        byte[] key = this.getBeanKey(instance.getClass(), instance.getId());
        try (JedisClientResource resource = JedisClientResource.create();){
            resource.getClient().expire(key, seconds);
        }
    }
}

