/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.server.session2.storage.redis;

import java.util.Set;
import kd.bos.flydb.common.FlyDBConstants;
import kd.bos.flydb.common.ServerConfig;
import kd.bos.flydb.common.ServerOption;
import kd.bos.flydb.common.config.Option;
import kd.bos.flydb.common.util.RedisSet;
import kd.bos.flydb.server.session2.storage.SessionManagerStorage;

public class SessionManagerStorageImpl
implements SessionManagerStorage {
    private static final String key = FlyDBConstants.getKeyWithRegion((String)"FLYDB_SESSIONS");
    private static final RedisSet storage = new RedisSet(SessionManagerStorageImpl.class.getName(), key);

    @Override
    public void register(String id) {
        storage.add(id);
        this.refreshExpireTime();
    }

    @Override
    public Set<String> list() {
        this.refreshExpireTime();
        return storage.list();
    }

    @Override
    public void unregister(String id) {
        this.refreshExpireTime();
        storage.remove(id);
    }

    @Override
    public boolean exist(String id) {
        this.refreshExpireTime();
        return storage.exist(id);
    }

    private void refreshExpireTime() {
        storage.expire((long)(ServerConfig.getSysConfiguration().getInt((Option)ServerOption.QueryTimeout) * 2));
    }
}

