/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.jdbc.internal;

import kd.bos.algo.DataType;

public final class Column {
    private String name;
    private String alias;
    private DataType dataType;
    private int precision;
    private int scale;

    public Column(String fieldName, String fieldAlias, DataType dataType) {
        assert (dataType != null);
        this.name = fieldName;
        this.alias = fieldAlias;
        this.dataType = dataType;
        kd.bos.flydb.server.http.packet.common.DataType toDataType = kd.bos.flydb.server.http.packet.common.DataType.convertToDataType((DataType)dataType);
        this.setPrecisionAndScale(toDataType);
    }

    private final void setPrecisionAndScale(kd.bos.flydb.server.http.packet.common.DataType toDataType) {
        switch (toDataType) {
            case BIGINT: {
                this.setPrecisionAndScale(19, 0);
                break;
            }
            case INTEGER: {
                this.setPrecisionAndScale(10, 0);
                break;
            }
            case DOUBLE: 
            case DECIMAL: {
                this.setPrecisionAndScale(23, 10);
                break;
            }
            case VARCHAR: {
                this.setPrecisionAndScale(Integer.MAX_VALUE, 0);
                break;
            }
            case DATE: 
            case TIME: 
            case DATETIME: {
                this.setPrecisionAndScale(3, 0);
                break;
            }
            case NULL: 
            case BOOLEAN: {
                this.setPrecisionAndScale(0, 0);
                break;
            }
        }
    }

    private void setPrecisionAndScale(int precision, int scale) {
        this.precision = precision;
        this.scale = scale;
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }
}

