/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.jdbc.internal;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.jdbc.internal.DatabaseMetaData;
import kd.bos.flydb.jdbc.internal.DriverUri;
import kd.bos.flydb.jdbc.internal.Exceptions;
import kd.bos.flydb.jdbc.internal.PreparedStatement;
import kd.bos.flydb.jdbc.internal.Statement;
import kd.bos.flydb.server.facade.DriverServerAPI;

public class Connection
implements java.sql.Connection {
    private static DriverServerAPI executor = DriverServerAPI.get();
    private final DriverUri uri;
    private final String connectionId;
    private final int fetchSize;
    private final ReentrantLock lock;
    private boolean closed;

    public Connection(DriverUri uri, ReentrantLock lock) throws SQLException {
        try {
            this.uri = uri;
            this.fetchSize = uri.getFetchSize();
            this.lock = lock;
            this.connectionId = executor.openSession(uri.getSessionContext(), "cosmic-internal");
        }
        catch (Exception e) {
            throw Exceptions.wrap(e);
        }
    }

    public ReentrantLock getLock() {
        return this.lock;
    }

    public DriverUri getUri() {
        return this.uri;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public static DriverServerAPI getExecutor() {
        return executor;
    }

    @Override
    public java.sql.Statement createStatement() throws SQLException {
        return new Statement(this, this.fetchSize);
    }

    @Override
    public java.sql.PreparedStatement prepareStatement(String sql) throws SQLException {
        return new PreparedStatement(this, sql, this.fetchSize);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported prepareCall(String sql)");
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return sql;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return true;
    }

    @Override
    public void commit() throws SQLException {
    }

    @Override
    public void rollback() throws SQLException {
    }

    @Override
    public void close() throws SQLException {
        if (!this.closed) {
            try {
                executor.closeSession(this.connectionId);
                this.closed = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public java.sql.DatabaseMetaData getMetaData() throws SQLException {
        return new DatabaseMetaData(this, this.uri);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return true;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.uri.getDatabase();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 2;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getWarnings()");
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public java.sql.Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported createStatement(int resultSetType, int resultSetConcurrency)");
    }

    @Override
    public java.sql.PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported prepareStatement(String sql, int resultSetType, int resultSetConcurrency)");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported prepareCall(String sql, int resultSetType, int resultSetConcurrency)");
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getTypeMap()");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported setTypeMap(Map<String, Class<?>> map)");
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported setHoldability(int holdability)");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getHoldability()");
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported setSavepoint()");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported setSavepoint(String name)");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported rollback(Savepoint savepoint)");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported releaseSavepoint(Savepoint savepoint)");
    }

    @Override
    public java.sql.Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability)");
    }

    @Override
    public java.sql.PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported repareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability)");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability)");
    }

    @Override
    public java.sql.PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported prepareStatement(String sql, int autoGeneratedKeys)");
    }

    @Override
    public java.sql.PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported prepareStatement(String sql, int[] columnIndexes)");
    }

    @Override
    public java.sql.PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported prepareStatement(String sql, String[] columnNames)");
    }

    @Override
    public Clob createClob() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported createClob()");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported createBlob()");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported createNClob()");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported createSQLXML()");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return true;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        throw new SQLClientInfoException();
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw new SQLClientInfoException();
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getClientInfo(String name)");
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getClientInfo()");
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported createArrayOf(String typeName, Object[] elements)");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported createStruct(String typeName, Object[] attributes)");
    }

    @Override
    public void setSchema(String schema) throws SQLException {
    }

    @Override
    public String getSchema() throws SQLException {
        return this.uri.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported abort(Executor executor)");
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported setNetworkTimeout(Executor executor, int milliseconds)");
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getNetworkTimeout()");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return iface.cast(this);
        }
        throw Exceptions.newSQLException(ErrorCode.ClientError_UnwrapFail, iface.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }
}

