/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.jdbc.internal;

import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import kd.bos.algo.DataType;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.jdbc.internal.Column;
import kd.bos.flydb.jdbc.internal.Connection;
import kd.bos.flydb.jdbc.internal.DriverUri;
import kd.bos.flydb.jdbc.internal.Exceptions;
import kd.bos.flydb.jdbc.internal.ResultSet;

public class DatabaseMetaData
implements java.sql.DatabaseMetaData {
    private final Connection connection;
    private final DriverUri driverUri;

    public DatabaseMetaData(Connection connection, DriverUri uri) {
        this.connection = connection;
        this.driverUri = uri;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return false;
    }

    @Override
    public String getURL() throws SQLException {
        return this.driverUri.getUrl();
    }

    @Override
    public String getUserName() throws SQLException {
        return String.valueOf(this.driverUri.getSessionContext().getUserId());
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return "FlyDB";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return "";
    }

    @Override
    public String getDriverName() throws SQLException {
        return "FlyDB JDBC Internal Driver";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return "5.0.014";
    }

    @Override
    public int getDriverMajorVersion() {
        return 5;
    }

    @Override
    public int getDriverMinorVersion() {
        return 14;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported storesUpperCaseIdentifiers()");
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported storesLowerCaseIdentifiers()");
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported storesMixedCaseIdentifiers()");
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported supportsMixedCaseQuotedIdentifiers()");
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported storesUpperCaseQuotedIdentifiers()");
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported storesLowerCaseQuotedIdentifiers()");
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported storesMixedCaseQuotedIdentifiers()");
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return "`";
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getSQLKeywords()");
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getNumericFunctions()");
    }

    @Override
    public String getStringFunctions() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getStringFunctions()");
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getSystemFunctions()");
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getTimeDateFunctions()");
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getSearchStringEscape()");
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getExtraNameCharacters()");
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return "schema";
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getProcedureTerm()");
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getCatalogTerm()");
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return true;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getMaxColumnNameLength()");
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getMaxColumnsInGroupBy()");
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getMaxColumnsInIndex()");
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getMaxColumnsInOrderBy()");
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return Short.MAX_VALUE;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return 50;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    @Override
    public java.sql.ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getProcedures(String catalog, String schemaPattern, String procedureNamePattern)");
    }

    @Override
    public java.sql.ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern)");
    }

    @Override
    public java.sql.ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        StringBuilder sql = new StringBuilder(48);
        sql.append("show tables");
        if (schemaPattern != null) {
            sql.append(" from ").append(schemaPattern);
            if (tableNamePattern != null) {
                sql.append(" where table_name = '").append(tableNamePattern).append('\'');
                if (types.length > 0) {
                    sql.append(" and table_type in (").append(String.join((CharSequence)",", types)).append(')');
                }
            }
        }
        return this.executeSql(sql.toString());
    }

    @Override
    public java.sql.ResultSet getSchemas() throws SQLException {
        return this.executeSql("show schemas");
    }

    @Override
    public java.sql.ResultSet getCatalogs() throws SQLException {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        data.add(new Object[]{this.driverUri.getDatabase()});
        Column column = new Column("catalog", "catalog", (DataType)DataType.StringType);
        return ResultSet.createResultSet(column, data);
    }

    @Override
    public java.sql.ResultSet getTableTypes() throws SQLException {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        data.add(new Object[]{"METADATA"});
        Column column = new Column("TABLE_TYPE", "TABLE_TYPE", (DataType)DataType.StringType);
        return ResultSet.createResultSet(column, data);
    }

    @Override
    public java.sql.ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        if (tableNamePattern == null) {
            throw new SQLException("Argument tableNamePattern can not be null");
        }
        return this.executeSql("show columns from " + tableNamePattern);
    }

    private java.sql.ResultSet executeSql(String sql) throws SQLException {
        Statement statement = this.connection.createStatement();
        java.sql.ResultSet resultSet = statement.executeQuery(sql);
        return resultSet;
    }

    @Override
    public java.sql.ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern)");
    }

    @Override
    public java.sql.ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern)");
    }

    @Override
    public java.sql.ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable)");
    }

    @Override
    public java.sql.ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getVersionColumns(String catalog, String schema, String table)");
    }

    @Override
    public java.sql.ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getPrimaryKeys(String catalog, String schema, String table)");
    }

    @Override
    public java.sql.ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getImportedKeys(String catalog, String schema, String table)");
    }

    @Override
    public java.sql.ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getExportedKeys(String catalog, String schema, String table)");
    }

    @Override
    public java.sql.ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable)");
    }

    @Override
    public java.sql.ResultSet getTypeInfo() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getTypeInfo()");
    }

    @Override
    public java.sql.ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate)");
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return false;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return false;
    }

    @Override
    public java.sql.ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types)");
    }

    @Override
    public java.sql.Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    @Override
    public java.sql.ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getSuperTypes(String catalog, String schemaPattern, String typeNamePattern)");
    }

    @Override
    public java.sql.ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getSuperTables(String catalog, String schemaPattern, String tableNamePattern)");
    }

    @Override
    public java.sql.ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern)");
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return false;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 0;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 0;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getRowIdLifetime()");
    }

    @Override
    public java.sql.ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        if (catalog == null || schemaPattern == null) {
            throw new SQLException("Argument catalog or schemaPattern must not be null");
        }
        if (!catalog.equals(this.driverUri.getDatabase())) {
            throw new SQLException("Argument catalog was differ to connection url's database");
        }
        return this.executeSql("show schemas where schema_name = '" + schemaPattern + '\'');
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return false;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    @Override
    public java.sql.ResultSet getClientInfoProperties() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getClientInfoProperties()");
    }

    @Override
    public java.sql.ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getFunctions(String catalog, String schemaPattern, String functionNamePattern)");
    }

    @Override
    public java.sql.ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern)");
    }

    @Override
    public java.sql.ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern)");
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return iface.cast(this);
        }
        throw Exceptions.newSQLException(ErrorCode.ClientError_UnwrapFail, iface.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }
}

