/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.jdbc.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import kd.bos.flydb.jdbc.internal.Connection;
import kd.bos.flydb.jdbc.internal.DriverUri;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class Driver
implements java.sql.Driver {
    private static final Log logger = LogFactory.getLog((String)Driver.class.getSimpleName());
    static final String DRIVER_NAME = "FlyDB JDBC Internal Driver";
    static int DRIVER_VERSION_MAJOR;
    static int DRIVER_VERSION_MINOR;

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        DriverUri uri = new DriverUri(url, info);
        ReentrantLock lock = new ReentrantLock();
        return new Connection(uri, lock);
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url.toLowerCase(Locale.ENGLISH).startsWith("jdbc:flydb://internal");
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return DRIVER_VERSION_MAJOR;
    }

    @Override
    public int getMinorVersion() {
        return DRIVER_VERSION_MINOR;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Use logging parameters for enabling logging.");
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException e) {
            throw new RuntimeException("Can't register driver!" + e.getMessage(), e);
        }
        String file = "/internal/version.properties";
        URL resource = Driver.class.getResource(file);
        Properties properties = new Properties();
        if (resource != null) {
            try (InputStream inputStream = Driver.class.getResourceAsStream(file);){
                properties.load(inputStream);
                String major = properties.getProperty("DRIVER_VERSION_MAJOR");
                String minor = properties.getProperty("DRIVER_VERSION_MINOR");
                if (Objects.nonNull(major)) {
                    DRIVER_VERSION_MAJOR = Integer.parseInt(major);
                }
                if (Objects.nonNull(minor)) {
                    DRIVER_VERSION_MINOR = Integer.parseInt(minor);
                }
            }
            catch (IOException e) {
                logger.warn("Reading version.properties error:" + e.getMessage(), (Throwable)e);
                DRIVER_VERSION_MAJOR = 1;
                DRIVER_VERSION_MINOR = 0;
            }
        }
    }
}

