/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.jdbc.internal;

import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import kd.bos.context.RequestContext;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.jdbc.internal.Exceptions;
import kd.bos.flydb.server.SessionContext;

public final class DriverUri {
    private static final String INTERNAL_STRING = "internal";
    private String database;
    private String schema;
    private int fetchSize = 5000;
    private SessionContext sessionContext;

    private DriverUri() {
    }

    public DriverUri(String url, Properties info) throws SQLException {
        this.parseUrl(url, info);
        this.initSessionContext();
    }

    private void initSessionContext() throws SQLException {
        RequestContext rc = RequestContext.get();
        if (rc == null || rc.getUserId() == null || rc.getAccountId() == null || rc.getTenantId() == null) {
            throw Exceptions.newSQLException(ErrorCode.ClientError_CurrentContextIsNull, new Object[0]);
        }
        this.sessionContext = new SessionContext(this.database, this.schema, rc.getTenantId(), rc.getAccountId(), rc.getCurrUserId());
    }

    private void parseUrl(String url, Properties properties) throws SQLException {
        try {
            String database;
            int optIndex;
            String urlParameters;
            String additionalParameters;
            String internalConnectionStr;
            int separator = url.indexOf("//");
            if (separator == -1) {
                throw new IllegalArgumentException("url parsing error : '//' is not present in the url " + url);
            }
            String urlPart = url.substring(separator + 2);
            if (urlPart == null) {
                throw new IllegalArgumentException("url parsing error : urlPart can not be null");
            }
            int paramIndex = urlPart.indexOf("?");
            if (paramIndex == -1) {
                internalConnectionStr = urlPart.trim().toLowerCase(Locale.ENGLISH);
                additionalParameters = null;
            } else {
                internalConnectionStr = urlPart.substring(0, paramIndex);
                additionalParameters = urlPart.substring(paramIndex);
            }
            if (internalConnectionStr == null || !INTERNAL_STRING.equals(internalConnectionStr)) {
                throw new IllegalArgumentException("url parsing error : can not find explicit internal-connection string in the url " + url);
            }
            if (additionalParameters != null && (urlParameters = additionalParameters.substring((optIndex = additionalParameters.indexOf("?")) + 1)) != null && !urlParameters.isEmpty()) {
                String[] parameters;
                for (String parameter : parameters = urlParameters.split("&")) {
                    int pos = parameter.indexOf(61);
                    if (pos == -1) {
                        properties.setProperty(parameter, "");
                        continue;
                    }
                    properties.setProperty(parameter.substring(0, pos), parameter.substring(pos + 1));
                }
            }
            this.database = (database = properties.getProperty("database")) == null ? "cosmic_db" : database;
            this.schema = properties.getProperty("schema");
            String fetchSize = properties.getProperty("fetchSize");
            this.fetchSize = fetchSize == null ? this.fetchSize : Integer.parseInt(fetchSize);
        }
        catch (IllegalArgumentException e) {
            throw Exceptions.newSQLException(ErrorCode.ClientError_URLValidError, e);
        }
    }

    public String getDatabase() {
        return this.database;
    }

    public String getSchema() {
        return this.schema;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public SessionContext getSessionContext() {
        return this.sessionContext;
    }

    public String getUrl() {
        DriverUri defaultUri = new DriverUri();
        StringBuilder sb = new StringBuilder();
        sb.append("jdbc:flydb://");
        sb.append(INTERNAL_STRING);
        sb.append("/");
        try {
            Field[] fields;
            boolean first = true;
            for (Field field : fields = DriverUri.class.getDeclaredFields()) {
                Object obj;
                if ("accountName".equals(field.getName()) || (obj = field.get(this)) == null || obj instanceof Properties && ((Properties)obj).size() <= 0) continue;
                if ("password".equals(field.getName())) {
                    sb.append(first ? (char)'?' : '&');
                    first = false;
                    sb.append(field.getName()).append('=');
                    sb.append("***");
                    continue;
                }
                if (field.getType().equals(String.class)) {
                    sb.append(first ? (char)'?' : '&');
                    first = false;
                    sb.append(field.getName()).append('=');
                    sb.append((String)obj);
                    continue;
                }
                if (field.getType().equals(Boolean.TYPE)) {
                    boolean defaultValue = field.getBoolean(defaultUri);
                    if (obj.equals(defaultValue)) continue;
                    sb.append(first ? (char)'?' : '&');
                    first = false;
                    sb.append(field.getName()).append('=');
                    sb.append(obj);
                    continue;
                }
                if (field.getType().equals(Integer.TYPE)) {
                    try {
                        int defaultValue = field.getInt(defaultUri);
                        if (obj.equals(defaultValue)) continue;
                        sb.append(first ? (char)'?' : '&');
                        sb.append(field.getName()).append('=').append(obj);
                        first = false;
                    }
                    catch (IllegalAccessException defaultValue) {}
                    continue;
                }
                if (field.getType().equals(Properties.class)) {
                    sb.append(first ? (char)'?' : '&');
                    first = false;
                    boolean firstProp = true;
                    Properties properties = (Properties)obj;
                    for (Map.Entry<Object, Object> objectEntry : properties.entrySet()) {
                        if (firstProp) {
                            firstProp = false;
                        } else {
                            sb.append('&');
                        }
                        sb.append(objectEntry.getKey()).append('=');
                        sb.append(objectEntry.getValue());
                    }
                    continue;
                }
                Object defaultValue = field.get(defaultUri);
                if (obj.equals(defaultValue)) continue;
                sb.append(first ? (char)'?' : '&');
                first = false;
                sb.append(field.getName()).append('=');
                sb.append(obj);
            }
        }
        catch (IllegalAccessException first) {
        }
        catch (SecurityException s) {
            throw new IllegalArgumentException("Security too restrictive : " + s.getMessage(), s);
        }
        return sb.toString();
    }
}

