/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.jdbc.internal;

import java.io.IOException;
import java.text.MessageFormat;
import kd.bos.exception.KDException;
import kd.bos.flydb.common.exception.CoreException;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.ExceptionUtil;
import kd.bos.flydb.jdbc.internal.SQLException;

public final class Exceptions {
    private Exceptions() {
    }

    public static java.sql.SQLException newUnsupportedException(Object ... args) {
        return Exceptions.newSQLException(ErrorCode.ClientError_UnsupportedFeature, args);
    }

    private static String format(ErrorCode code, Object ... args) {
        String message = MessageFormat.format(code.reason, args);
        if (!message.endsWith(".")) {
            return message + '.';
        }
        return message;
    }

    public static java.sql.SQLException newSQLException(ErrorCode code, Object ... args) {
        String reason = Exceptions.format(code, args);
        return new SQLException(reason, "", code.vendorCode);
    }

    public static java.sql.SQLException newSQLException(Throwable throwable, ErrorCode code, Object ... args) {
        String reason = Exceptions.format(code, args);
        return new SQLException(reason, "", code.vendorCode, throwable);
    }

    public static java.sql.SQLException wrap(Throwable exception) {
        if ((exception = ExceptionUtil.tryUnwrapCoreException((Throwable)exception)) instanceof CoreException) {
            return new SQLException(exception.getMessage(), "", ((CoreException)exception).getVendorCode());
        }
        if (exception instanceof KDException) {
            KDException kdException = (KDException)exception;
            if ("DubboServiceLookup".equalsIgnoreCase(kdException.getErrorCode().getCode())) {
                return new SQLException(ErrorCode.ClientError_ServerUnavailable.reason, "", ErrorCode.ClientError_ServerUnavailable.vendorCode, exception);
            }
        } else {
            if (exception instanceof SQLException) {
                return (java.sql.SQLException)exception;
            }
            if (exception instanceof IOException) {
                return new SQLException(exception.getMessage(), "", ErrorCode.ClientError_IOException.vendorCode, exception);
            }
        }
        return new SQLException(exception.getMessage(), "", ErrorCode.ClientError_Unexpected.vendorCode, exception);
    }
}

