/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.jdbc.internal;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import kd.bos.flydb.jdbc.internal.Connection;
import kd.bos.flydb.jdbc.internal.ResultSet;
import kd.bos.flydb.jdbc.internal.Statement;
import kd.bos.flydb.jdbc.util.ClientParser;
import kd.bos.flydb.jdbc.util.ParameterList;
import kd.bos.flydb.jdbc.util.encode.BigDecimalEncoder;
import kd.bos.flydb.jdbc.util.encode.BooleanEncoder;
import kd.bos.flydb.jdbc.util.encode.ByteEncoder;
import kd.bos.flydb.jdbc.util.encode.DateEncoder;
import kd.bos.flydb.jdbc.util.encode.DoubleEncoder;
import kd.bos.flydb.jdbc.util.encode.Encoder;
import kd.bos.flydb.jdbc.util.encode.FloatEncoder;
import kd.bos.flydb.jdbc.util.encode.IntegerEncoder;
import kd.bos.flydb.jdbc.util.encode.LongEncoder;
import kd.bos.flydb.jdbc.util.encode.ShortEncoder;
import kd.bos.flydb.jdbc.util.encode.StringEncoder;
import kd.bos.flydb.jdbc.util.encode.TimeEncoder;
import kd.bos.flydb.jdbc.util.encode.TimestampEncoder;
import kd.bos.flydb.jdbc.util.parameter.Parameter;
import kd.bos.flydb.jdbc.util.parameter.ParameterWithCalendar;

public class PreparedStatement
extends Statement
implements java.sql.PreparedStatement {
    private ClientParser parser;
    private ParameterList parameters;

    public PreparedStatement(Connection connection, String sql, int fetchSize) {
        super(connection, fetchSize);
        this.parser = ClientParser.parameterParts((String)sql, (boolean)false);
        this.parameters = new ParameterList(this.parser.getParamCount());
    }

    @Override
    public java.sql.ResultSet executeQuery() throws SQLException {
        return super.executeQuery(this.getExecuteSql());
    }

    private String getExecuteSql() {
        StringBuilder ret = new StringBuilder();
        int pos = 0;
        for (int i = 0; i < this.parser.getParamPositions().size(); ++i) {
            int paramPos = (Integer)this.parser.getParamPositions().get(i);
            byte[] paramBeforeBytes = new byte[paramPos - pos];
            System.arraycopy(this.parser.getQuery(), pos, paramBeforeBytes, 0, paramPos - pos);
            byte[] paramBytes = this.parameters.get(i).toEncodeText().getBytes();
            pos = paramPos + 1;
            byte[] merge = new byte[paramBeforeBytes.length + paramBytes.length];
            System.arraycopy(paramBeforeBytes, 0, merge, 0, paramBeforeBytes.length);
            System.arraycopy(paramBytes, 0, merge, paramBeforeBytes.length, paramBytes.length);
            ret.append(new String(merge, StandardCharsets.UTF_8));
        }
        if (this.parser.getQuery().length - pos > 0) {
            byte[] bytes = new byte[this.parser.getQuery().length - pos];
            System.arraycopy(this.parser.getQuery(), pos, bytes, 0, this.parser.getQuery().length - pos);
            ret.append(new String(bytes, StandardCharsets.UTF_8));
        }
        return ret.toString();
    }

    @Override
    public void addBatch() throws SQLException {
    }

    @Override
    public void clearParameters() throws SQLException {
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.currResult instanceof ResultSet) {
            return this.currResult.getMetaData();
        }
        throw new SQLException("Unsupported getMetaData before executeQuery()");
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new SQLException("Unsupported getParameterMetaData()");
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, (kd.bos.flydb.jdbc.util.Parameter)Parameter.NULL_PARAMETER);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, (kd.bos.flydb.jdbc.util.Parameter)new Parameter((Encoder)BooleanEncoder.INSTANCE, (Object)x));
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, (kd.bos.flydb.jdbc.util.Parameter)new Parameter((Encoder)ByteEncoder.INSTANCE, (Object)x));
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, (kd.bos.flydb.jdbc.util.Parameter)new Parameter((Encoder)ShortEncoder.INSTANCE, (Object)x));
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, (kd.bos.flydb.jdbc.util.Parameter)new Parameter((Encoder)IntegerEncoder.INSTANCE, (Object)x));
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, (kd.bos.flydb.jdbc.util.Parameter)new Parameter((Encoder)LongEncoder.INSTANCE, (Object)x));
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, (kd.bos.flydb.jdbc.util.Parameter)new Parameter((Encoder)FloatEncoder.INSTANCE, (Object)Float.valueOf(x)));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, (kd.bos.flydb.jdbc.util.Parameter)new Parameter((Encoder)DoubleEncoder.INSTANCE, (Object)x));
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, (kd.bos.flydb.jdbc.util.Parameter)new Parameter((Encoder)BigDecimalEncoder.INSTANCE, (Object)x));
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, (kd.bos.flydb.jdbc.util.Parameter)new Parameter((Encoder)StringEncoder.INSTANCE, (Object)x));
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.checkIndex(parameterIndex);
        throw new SQLException("Unsupported setBytes(int parameterIndex, byte[] x)");
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, (kd.bos.flydb.jdbc.util.Parameter)new Parameter((Encoder)DateEncoder.INSTANCE, (Object)x));
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, (kd.bos.flydb.jdbc.util.Parameter)new Parameter((Encoder)TimeEncoder.INSTANCE, (Object)x));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, (kd.bos.flydb.jdbc.util.Parameter)new Parameter((Encoder)TimestampEncoder.INSTANCE, (Object)x));
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLException("Unsupported setAsciiStream(int parameterIndex, InputStream x, int length)");
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLException("Unsupported setUnicodeStream(int parameterIndex, InputStream x, int length)");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLException("Unsupported setBinaryStream(int parameterIndex, InputStream x, int length)");
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setInternalObject(parameterIndex, x, targetSqlType, null);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.setInternalObject(parameterIndex, x, null, null);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        throw new SQLException("Unsupported setCharacterStream(int parameterIndex, Reader reader, int length)");
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        throw new SQLException("Unsupported setBlob(int parameterIndex, Blob x)");
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        throw new SQLException("Unsupported setClob(int parameterIndex, Clob x)");
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw new SQLException("Unsupported setArray(int parameterIndex, Array x)");
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, (kd.bos.flydb.jdbc.util.Parameter)new ParameterWithCalendar((Encoder)DateEncoder.INSTANCE, (Object)x, cal));
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, (kd.bos.flydb.jdbc.util.Parameter)new ParameterWithCalendar((Encoder)TimeEncoder.INSTANCE, (Object)x, cal));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, (kd.bos.flydb.jdbc.util.Parameter)new ParameterWithCalendar((Encoder)TimestampEncoder.INSTANCE, (Object)x, cal));
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, (kd.bos.flydb.jdbc.util.Parameter)Parameter.NULL_PARAMETER);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw new SQLException("Unsupported setURL(int parameterIndex, URL x)");
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new SQLException("Unsupported setRowId(int parameterIndex, RowId x)");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        throw new SQLException("Unsupported setNString(int parameterIndex, String value)");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new SQLException("Unsupported setNCharacterStream(int parameterIndex, Reader value, long length)");
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new SQLException("Unsupported setNClob(int parameterIndex, NClob value)");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLException("Unsupported setClob(int parameterIndex, Reader reader, long length)");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLException("Unsupported setBlob(int parameterIndex, InputStream inputStream, long length)");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLException("Unsupported setNClob(int parameterIndex, Reader reader, long length)");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLException("Unsupported setSQLXML(int parameterIndex, SQLXML xmlObject)");
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.setInternalObject(parameterIndex, x, targetSqlType, Long.valueOf(scaleOrLength));
    }

    private void setInternalObject(int parameterIndex, Object obj, Integer targetSqlType, Long scaleOrLength) throws SQLException {
        this.checkIndex(parameterIndex);
        if (obj == null) {
            this.parameters.set(parameterIndex - 1, (kd.bos.flydb.jdbc.util.Parameter)Parameter.NULL_PARAMETER);
            return;
        }
        if (targetSqlType != null) {
            switch (targetSqlType) {
                case -8: 
                case 70: 
                case 2000: 
                case 2002: 
                case 2003: 
                case 2006: 
                case 2009: {
                    throw new SQLException("Type not supported");
                }
            }
            if (obj instanceof String || obj instanceof Character) {
                if (targetSqlType == 2004) {
                    throw new SQLException(String.format("Cannot convert a %s to a Blob", obj instanceof String ? "string" : "character"));
                }
                String str = obj instanceof String ? (String)obj : ((Character)obj).toString();
                try {
                    switch (targetSqlType) {
                        case -7: 
                        case 16: {
                            this.setBoolean(parameterIndex, !"false".equalsIgnoreCase(str) && !"0".equals(str));
                            return;
                        }
                        case -6: {
                            this.setByte(parameterIndex, Byte.parseByte(str));
                            return;
                        }
                        case 5: {
                            this.setShort(parameterIndex, Short.parseShort(str));
                            return;
                        }
                        case 4: {
                            this.setInt(parameterIndex, Integer.parseInt(str));
                            return;
                        }
                        case 6: 
                        case 8: {
                            this.setDouble(parameterIndex, Double.parseDouble(str));
                            return;
                        }
                        case 7: {
                            this.setFloat(parameterIndex, Float.parseFloat(str));
                            return;
                        }
                        case -5: {
                            this.setLong(parameterIndex, Long.parseLong(str));
                            return;
                        }
                        case 2: 
                        case 3: {
                            this.setBigDecimal(parameterIndex, new BigDecimal(str));
                            return;
                        }
                        case -16: 
                        case -15: 
                        case -9: 
                        case -1: 
                        case 1: 
                        case 12: 
                        case 2005: 
                        case 2011: {
                            this.setString(parameterIndex, str);
                            return;
                        }
                        case 93: {
                            if (str.startsWith("0000-00-00")) {
                                this.setTimestamp(parameterIndex, null);
                            } else {
                                this.setTimestamp(parameterIndex, Timestamp.valueOf(str));
                            }
                            return;
                        }
                        case 92: {
                            this.setTime(parameterIndex, Time.valueOf((String)obj));
                            return;
                        }
                    }
                    throw new SQLException(String.format("Could not convert [%s] to %s", str, targetSqlType));
                }
                catch (IllegalArgumentException e) {
                    throw new SQLException(String.format("Could not convert [%s] to java.sql.Type %s", str, targetSqlType), "HY000", e);
                }
            }
            if (obj instanceof Number) {
                Number bd = (Number)obj;
                switch (targetSqlType) {
                    case -6: {
                        this.setByte(parameterIndex, bd.byteValue());
                        return;
                    }
                    case 5: {
                        this.setShort(parameterIndex, bd.shortValue());
                        return;
                    }
                    case 4: {
                        this.setInt(parameterIndex, bd.intValue());
                        return;
                    }
                    case -5: {
                        this.setLong(parameterIndex, bd.longValue());
                        return;
                    }
                    case 6: 
                    case 8: {
                        this.setDouble(parameterIndex, bd.doubleValue());
                        return;
                    }
                    case 7: {
                        this.setFloat(parameterIndex, bd.floatValue());
                        return;
                    }
                    case 2: 
                    case 3: {
                        if (obj instanceof BigDecimal) {
                            this.setBigDecimal(parameterIndex, (BigDecimal)obj);
                        } else if (obj instanceof Double || obj instanceof Float) {
                            this.setDouble(parameterIndex, bd.doubleValue());
                        } else {
                            this.setLong(parameterIndex, bd.longValue());
                        }
                        return;
                    }
                    case -7: {
                        this.setBoolean(parameterIndex, bd.shortValue() != 0);
                        return;
                    }
                    case 1: 
                    case 12: {
                        this.setString(parameterIndex, bd.toString());
                        return;
                    }
                }
                throw new SQLException(String.format("Could not convert [%s] to %s", bd, targetSqlType));
            }
            if (obj instanceof byte[]) {
                if (targetSqlType == -2 || targetSqlType == -3 || targetSqlType == -4) {
                    this.setBytes(parameterIndex, (byte[])obj);
                    return;
                }
                throw new SQLException("Can only convert a byte[] to BINARY, VARBINARY, LONGVARBINARY type");
            }
        }
        throw new SQLException(String.format("Type %s not supported type", obj.getClass().getName()));
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new SQLException("Unsupported setAsciiStream(int parameterIndex, InputStream x, long length)");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new SQLException("Unsupported setBinaryStream(int parameterIndex, InputStream x, long length)");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLException("Unsupported setCharacterStream(int parameterIndex, Reader reader, long length)");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLException("Unsupported setAsciiStream(int parameterIndex, InputStream x)");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLException("Unsupported setBinaryStream(int parameterIndex, InputStream x)");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLException("Unsupported setCharacterStream(int parameterIndex, Reader reader)");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new SQLException("Unsupported setNCharacterStream(int parameterIndex, Reader value)");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLException("Unsupported setClob(int parameterIndex, Reader reader)");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new SQLException("Unsupported setBlob(int parameterIndex, InputStream inputStream)");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLException("Unsupported setNClob(int parameterIndex, Reader reader)");
    }

    private void checkIndex(int index) throws SQLException {
        if (index <= 0) {
            throw new SQLException(String.format("wrong parameter index %s", index));
        }
    }

    @Override
    public boolean execute() throws SQLException {
        throw new SQLException("Unsupported execute()");
    }

    @Override
    public int executeUpdate() throws SQLException {
        throw new SQLException("Unsupported executeUpdate()");
    }

    @Override
    public java.sql.ResultSet executeQuery(String sql) throws SQLException {
        throw new SQLException("executeQuery(String sql) cannot be called on preparedStatement.");
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        throw new SQLException("executeQuery(String sql) cannot be called on preparedStatement.");
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        throw new SQLException("execute(String sql) cannot be called on preparedStatement.");
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new SQLException("addBatch(String sql) cannot be called on preparedStatement.");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new SQLException("Unsupported executeBatch()");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("executeUpdate(String sql, int autoGeneratedKeys) cannot be called on preparedStatement.");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("executeUpdate(String sql, int[] columnIndexes) cannot be called on preparedStatement.");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("executeUpdate(String sql, String[] columnNames) cannot be called on preparedStatement.");
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("execute(String sql, int autoGeneratedKeys) cannot be called on preparedStatement.");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("execute(String sql, int[] columnIndexes) cannot be called on preparedStatement.");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("execute(String sql, String[] columnNames) cannot be called on preparedStatement.");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return iface.cast(this);
        }
        throw new SQLException("The receiver is not a wrapper for " + iface.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }
}

